//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_EglTraceMapper_h
#define Candera_EglTraceMapper_h

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageTrace.h>
#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>

namespace Candera {
 
/**
 * @brief   The EglTraceMapper is a helper class used by different devices to map EglError types to Strings.
 */
class EglTraceMapper
{
    public:
        /**
         *  A EglError type is mapped to a String.
         *  @param eglErrorType The Egl type that is mapped.
         *  @return The mapped string.
         */      
        static const Char* MapEglErrorToString(EGLint eglErrorType);

};

CANDERA_DEVICE_PACKAGE_TRACE(Egl)

#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
// Logging Enabled

#define CANDERA_EGL_CHECK_ERROR_NO_RETURN(text) \
{ \
    const UInt32 eglError = static_cast<UInt32>(eglGetError()); \
    if (EGL_SUCCESS != eglError) { \
        FEATSTD_LOG_ERROR("Text: %s Error: %s.",text, EglTraceMapper::MapEglErrorToString(eglError)); \
    } \
}

#else
// Release build.
#define CANDERA_EGL_CHECK_ERROR_NO_RETURN(text)

#endif


} // namespace Candera

#endif// Candera_EglTraceMapper_h
