//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "EglTraceMapper.h"

namespace Candera {
    
    const Char* EglTraceMapper::MapEglErrorToString(EGLint eglErrorType) {
        const Char* ret = 0;
#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
        switch(eglErrorType) {
            case EGL_SUCCESS:               ret = "EGL_SUCCESS"; break;
            case EGL_NOT_INITIALIZED:       ret = "EGL_NOT_INITIALIZED"; break;
            case EGL_BAD_ACCESS:            ret = "EGL_BAD_ACCESS"; break;
            case EGL_BAD_ALLOC:             ret = "EGL_BAD_ALLOC"; break;
            case EGL_BAD_ATTRIBUTE:         ret = "EGL_BAD_ATTRIBUTE"; break;
            case EGL_BAD_CONFIG:            ret = "EGL_BAD_CONFIG"; break;
            case EGL_BAD_CONTEXT:           ret = "EGL_BAD_CONTEXT"; break;
            case EGL_BAD_CURRENT_SURFACE:   ret = "EGL_BAD_CURRENT_SURFACE"; break;
            case EGL_BAD_DISPLAY:           ret = "EGL_BAD_DISPLAY"; break;
            case EGL_BAD_MATCH:             ret = "EGL_BAD_MATCH"; break;
            case EGL_BAD_NATIVE_PIXMAP:     ret = "EGL_BAD_NATIVE_PIXMAP"; break;
            case EGL_BAD_NATIVE_WINDOW:     ret = "EGL_BAD_NATIVE_WINDOW"; break;
            case EGL_BAD_PARAMETER:         ret = "EGL_BAD_PARAMETER"; break;
            case EGL_BAD_SURFACE:           ret = "EGL_BAD_SURFACE"; break;
            case EGL_CONTEXT_LOST:          ret = "EGL_CONTEXT_LOST"; break;
            default:                        ret = "UNKNOWN_EGL_ERROR"; break;
        }
#else
        FEATSTD_UNUSED(eglErrorType);
#endif
        return ret;
    }
    
    static EGLint g_eglError = EGL_SUCCESS;
 
    bool CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Egl)::WasLastErrorSet()
    {
        return (g_eglError != EGL_SUCCESS);
    }
    bool CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Egl)::IsErrorSet()
    {
#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
        g_eglError = eglGetError();
#endif
        return WasLastErrorSet();
    }
    const Char* CANDERA_DEVICE_PACKAGE_TRACE_CLASS(Egl)::GetLastErrorText()
    {
#ifdef FEATSTD_GLERRORS_AND_EGLERRORS_ENABLED
        return EglTraceMapper::MapEglErrorToString(g_eglError);
#else
        return 0;
#endif
    }
}
