//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENERIC_BITMAP_EXTENDED_CONVERTER_H)
#define GENERIC_BITMAP_EXTENDED_CONVERTER_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapConvertor.h>

namespace Candera
{
    class GenericBitmapFormat;
    namespace GenericBitmapConvertor
    {

        /**
         *  Creates a convertor object used by GenericBitmapConvertor
         *  as information when traversing and converting bitmaps.
         *  This specialization generates the data from GenericBitmapFormat.
         *  @param dstWidth width of the bitmap.
         *  @param dstHeight height of the bitmap.
         *  @param dstExtProp pixel properties of the bitmap.
         *  @return ConvertorInfo object.
         */
        ConvertorInfo GetGenericBitmapExtendedConvertorInfo(
            UInt32 dstWidth, UInt32 dstHeight,
            const GenericBitmapFormat* dstExtProp);

    } //namespace GenericBitmapConvertor

} //namespace Candera

#endif // GENERIC_BITMAP_EXTENDED_CONVERTER_H

