//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericBitmapConvertor.h"

#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapBaseConvertor.h>
#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapExtendedConvertor.h>

#include <CanderaPlatform/Device/Common/BitmapConverter/GenericLinear2DDirectAccessBitmap.h>
#include <CanderaPlatform/Device/Common/BitmapConverter/GenericRunLengthEncodedBitmap.h>
#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapPixelConvertor.h>

#include <CanderaPlatform/Device/Common/BitmapConverter/GenericHostType.h>

#include "GenericBitmapConvertorImpl.h"
namespace Candera
{
    namespace GenericBitmapConvertor
    {
static bool Convert(
    const ConvertorInfo& dst,
    UInt8* dstBuffer, UInt32* dstBufferSize,
    const ConvertorInfo& src,
    const UInt8* srcBuffer, UInt32 srcBufferSize,
    PixelConversionType conversionType)
{
    typedef Selector<
        BppSelector,
        0,
        BppSelector::c_maxBits,
        0,
        BppSelector::c_maxBits>
        ConvertorSelector;
    const BaseConvertor* convertor = ConvertorSelector::Get(dst, src);
    if (convertor != 0) {
        return convertor->Convert(dst, dstBuffer, dstBufferSize, src, srcBuffer, srcBufferSize, conversionType);
    }
    else {
        return false;
    }
}

bool Convert(
    UInt32 dstWidth, UInt32 dstHeight,
    Int dstPixelFormat,
    Bitmap::PackAlignment dstColorPackAllignment,
    UInt8* dstBuffer, UInt32* dstBufferSize,
    const GenericBitmapFormat* dstExtProp,
    UInt32 srcWidth, UInt32 srcHeight,
    Int srcPixelFormat,
    Bitmap::PackAlignment srcColorPackAllignment,
    const UInt8* srcBuffer, UInt32 srcBufferSize,
    const GenericBitmapFormat* srcExtProp,
    PixelConversionType conversionType)
{
    if((dstBuffer == 0) || (dstBufferSize == 0) || (srcBuffer == 0)) {
        return false;
    }
    ConvertorInfo dst;
    if (dstExtProp == 0) {
        dst = GetGenericBitmapBaseConvertorInfo(dstWidth, dstHeight,
            dstPixelFormat, dstColorPackAllignment);
    }
    else {
        dst = GetGenericBitmapExtendedConvertorInfo(dstWidth, dstHeight, dstExtProp);
    }

    ConvertorInfo src;
    if (srcExtProp == 0) {
        src = GetGenericBitmapBaseConvertorInfo(srcWidth, srcHeight,
            srcPixelFormat,
            srcColorPackAllignment);
    }
    else {
        src = GetGenericBitmapExtendedConvertorInfo(srcWidth, srcHeight, srcExtProp);
    }

    return Convert(dst, dstBuffer, dstBufferSize, src, srcBuffer, srcBufferSize, conversionType);
} //Convert

bool Convert(
    UInt32 dstWidth, UInt32 dstHeight,
    Int dstPixelFormat,
    Bitmap::PackAlignment dstColorPackAllignment,
    UInt8* dstBuffer, UInt32* dstBufferSize,
    const GenericBitmapFormat* dstExtProp,
    UInt32 srcWidth, UInt32 srcHeight,
    Int srcPixelFormat,
    Bitmap::PackAlignment srcColorPackAllignment,
    const UInt8* srcBuffer, UInt32 srcBufferSize,
    const GenericBitmapFormat* srcExtProp)
{
    return Convert(
        dstWidth, dstHeight,
        dstPixelFormat,
        dstColorPackAllignment,
        dstBuffer, dstBufferSize,
        dstExtProp,
        srcWidth, srcHeight,
        srcPixelFormat,
        srcColorPackAllignment,
        srcBuffer, srcBufferSize,
        srcExtProp,
        RoundLinearConversion);
}
    } //namespace GenericBitmapConvertor
} //namespace Candera
