//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef GENERIC_BITMAP_ACCESS_H
#define GENERIC_BITMAP_ACCESS_H

#include <Candera/Environment.h>

namespace Candera
{
/**
 *  @brief Provides access description for the bitmap data. This type of access 
 *  descriptor is used by the software bitmap converter and by a few platforms.
 */
enum GenericBitmapAccess {
    Linear2DDirectAccess = 0, ///< Direct access of data stored linearly in a 2D pattern.
    
    /**
     *  Run length encoding, with 8 bit block header, first bit set to one
     *  meaning compressed, and the rest of 7 bits being a 0-based size of the block
     */ 
    RunLengthEncoding = 1,
    
    RunLenghtEncoding = RunLengthEncoding, 
    
    OneBasedRunLengthEncoding = 2, ///< Same as RunLengthEncoding, except block size is 1-based.
    GenericBitmapAccessItemCount = 3
};

/**
 *  @brief Provides description of the endianness of the bitmap data.
 */
enum GenericBitmapEndianness {
    LittleEndianBitmapWord, ///< Little endian bitmap word
    BigEndianBitmapWord,    ///< Big endian bitmap word
    BigEndianBitmapWordLittleEndianBitmapPixel, ///< Big endian bitmap word, little endian bitmap pixel.
    BitEndianBitmapWordLittleEndianBitmapPixel = BigEndianBitmapWordLittleEndianBitmapPixel, // spelling mistake, left for backwards compatibility
    GenericBitmapEndiannessItemCount
};
} //namespace Candera

#endif //GENERIC_BITMAP_ACCESS_H

