//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_RENDERTARGET_3D_CLEARMODE_H)
    #define CANDERAPLATFORM_RENDERTARGET_3D_CLEARMODE_H

#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>
#include <Candera/Environment.h>
#include <FeatStd/MemoryManagement/SharedPointer.h>

namespace Candera {

    class ClearMode;
    class RenderTarget;

    /** @addtogroup CommonDevice
     *  @{
     */

    /**
     * @brief ClearMode shareable wrapper.
     *
     * A SharedClearMode can be associated to one or multiple
     *  RenderTarget3D instances and it will be used to clear it before the
     *  first Camera is rendered by the Renderer::RenderAllCameras method.
     */
    class SharedClearMode {
    public:
        typedef FeatStd::MemoryManagement::SharedPointer<SharedClearMode> SharedPointer;

        SharedClearMode() : m_clearMode(0) {}

        /**
         * @brief Create a SharedClearMode instance.
         *
         * @return SharedClearMode shared pointer.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
        
        /**
         * Associate a ClearMode.
         * 
         * An associated ClearMode is needed by the SharedClearMode to
         *  be taken into consideration by the Renderer.
         *
         * @param clearMode to be associated.
         */
        void SetClearMode(ClearMode* clearMode) { m_clearMode = clearMode; }

        /**
         * @brief Retrieve the associated ClearMode.
         *
         * @return associated ClearMode.
         */
        const ClearMode* GetClearMode() const { return m_clearMode; }
        ClearMode* GetClearMode() { return m_clearMode; }
    private:
        ClearMode* m_clearMode;

        FEATSTD_SHARED_POINTER_DECLARATION();
    };


/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_RENDERTARGET_3D_CLEARMODE_H
