//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_RENDERTARGETLISTENERCOLLECTION_H)
#define CANDERAPLATFORM_RENDERTARGETLISTENERCOLLECTION_H

#include <Candera/EngineBase/Common/ListenerContainer.h>
#include <FeatStd/Event/EventListener.h>
#include <FeatStd/Event/Event.h>
#include <FeatStd/Event/EventSource.h>

namespace Candera { namespace Internal {

    template <typename EventSourceProvider>
    struct InternalEventSourceAccess
    {
        static FeatStd::EventSource& GetEventSource()
        {
            return EventSourceProvider::GetEventSource();
        }
    };

    template <typename Trigger>
    struct RenderTargetEventListenerCollection
    {
    public:
        enum EventTypes
        {
            BeforeSwap,
            AfterSwap,
            Destroy
        };

        class EventBase : public FeatStd::Event
        {
        public:
            FEATSTD_RTTI_TEMPLATE_DEFINITION(EventBase, FeatStd::Event);
            virtual ~EventBase() {}
            Trigger* GetRenderTarget() const { return m_renderTarget; }

        protected:
            EventBase(Trigger* renderTarget):m_renderTarget(renderTarget) { }

        private:
            Trigger* m_renderTarget;
        };

        template <EventTypes EventType>
        class TEvent : public EventBase
        {
        public:
            FEATSTD_RTTI_TEMPLATE_DEFINITION(TEvent, EventBase);
            TEvent(Trigger* renderTarget):EventBase(renderTarget) { }
        };

        template <EventTypes EventType>
        class ListenerContainerEvent : public Candera::Internal::ListenerContainer<FeatStd::EventListener>::Event
        {
            typedef TEvent<EventType> Event;
        public:
            ListenerContainerEvent(Trigger* renderTarget):m_event(renderTarget) { }
            virtual void Notify(FeatStd::EventListener* listener) override { static_cast<void>(listener->OnEvent(m_event)); }

        private:
            Event m_event;
        };


    };

}}   // namespace Candera::Internal

#endif  // CANDERAPLATFORM_RENDERTARGETLISTENERCOLLECTION_H
