//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_RENDERTARGET_3D_H)
    #define CANDERAPLATFORM_RENDERTARGET_3D_H

#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>
#include <CanderaPlatform/Device/Common/Base/RenderTarget.h>
#include <CanderaPlatform/Device/Common/Base/SharedClearMode.h>

namespace Candera {

class ContextResourcePool;

/** @addtogroup CommonDevice
 *  @{
 */

/**
 *  @brief RenderTarget3D is a render target dedicated to the Candera 3D API including native device context handling.
 */
class RenderTarget3D : public RenderTarget {
    public:

        /// Constructor
        CANDERA_DEPRECATED_3_0_0("Objects should not inherit directly from "
            "RenderTarget3D. Derived classes should be either ContextProvider3D "
            "or ContextDelegator3D.",
            RenderTarget3D());

        /// Destructor
        virtual ~RenderTarget3D()
        {
        }

        /**
         *  Returns the native device context handle, which is typically not used by applications directly.
         *  A native device context stores the render states associated to this RenderTarget3D.
         *  @return     Pointer to native device context handle.
         */
        virtual void* GetContextHandle() const { return 0; }

        /**
         *  Returns the ContextResourcePool associated with this render target.
         *  This is determined during Upload and the source is platform
         *  dependent, being either retrieved from another render target,
         *  retrieved from a display, retrieved from an 
         *  @return     Pointer to the ContextResourcePool object or 0 if the 
         *              render target was not updated (explicitly or implicitly
         *              during upload).
         */
        virtual const ContextResourcePool* GetContextResourcePool() const { return 0; }
        ContextResourcePool* GetContextResourcePool();

        /**
         * @brief Set a RenderTarget3DClearMode.
         *
         * If AutoClear is enabled on this RenderTarget, the ClearMode will be
         *  used by the Renderer::RenderAllCameras to clear the entire
         *  RenderTarget before rendering the first Camera.
         *
         *  @param clearMode Clear Mode to be set.
         */
        CANDERA_DEPRECATED_3_3_0("Please use a camera with clearing enabled instead.",
            void SetClearMode(const SharedClearMode::SharedPointer& clearMode)
        );

        /**
         * @brief Get the RenderTarget3DClearMode.
         *
         * @return associated RenderTarget3DClearMode.
         */
        CANDERA_DEPRECATED_3_3_0("Please use a camera with clearing enabled instead.",
            SharedClearMode::SharedPointer GetSharedClearMode() const
        );

    protected:
        /**
         *  Returns the width of the surface. This could be different from Surface::GetWidth.
         *  This is the value that should be used when the render target is used as a
         *  destination surface (e.g. in viewport calculation), as opposed to the value returned
         *  by Surface:GetWidth that represents the size of the visual appearance of the
         *  render target and is used in determining interaction with the render target
         *  (e.g. in picking).
         *  @return     Width of the surface.
         */
        virtual Int GetActualWidth() const { return GetWidth(); }

        /**
         *  Returns the height of the surface. This could be different from Surface::GetHeight.
         *  This is the value that should be used when the render target is used as a
         *  destination surface (e.g. in viewport calculation), as opposed to the value returned
         *  by Surface:GetHeight that represents the size of the visual appearance of the
         *  render target and is used in determining interaction with the render target
         *  (e.g. in picking).
         *  @return     Height of the surface.
         */
        virtual Int GetActualHeight() const { return GetHeight(); }

    private:
        friend class Renderer;
        friend class RenderDevice;
        friend class ContextProvider3D;
        friend class ContextDelegator3D;

        /// Constructor used by ContextProvider3D and ContextDelegator3D.
        explicit RenderTarget3D(Int) {}

        SharedClearMode::SharedPointer m_clearMode;
};

/** @}*/ //end of CommonDevice

inline RenderTarget3D::RenderTarget3D() {}
inline ContextResourcePool* RenderTarget3D::GetContextResourcePool() 
{ 
    return const_cast<ContextResourcePool*>(
        const_cast<const RenderTarget3D*>(
            this)->GetContextResourcePool()); 
}

}   // namespace Candera

#endif  // CANDERAPLATFORM_RENDERTARGET_3D_H
