//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_RENDERTARGET_2D_H)
    #define CANDERAPLATFORM_RENDERTARGET_2D_H

#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>
#include <CanderaPlatform/Device/Common/Base/RenderTarget.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Base/SharedClearMode2D.h>

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

/**
 *  @brief RenderTarget2D can be used inside the Candera 2D API as render target. RenderTarget2D is associated to a 2D
 *  context. As such, a render target needs to be activated so that a 2D call would use this context.
 */
class RenderTarget2D : public RenderTarget {
    public:
        /**
         * Constructor
         */
        RenderTarget2D()
        {
        }

        /**
         * Destructor
         */
        virtual ~RenderTarget2D()
        {
        }

        /**
         *  Returns the 2D context. The context can be used in the 2D API.
         *  @return     The 2D context handle.
         */
        virtual ContextHandle2D Get2DContextHandle() = 0;

        /**
         * @brief Set a RenderTarget2DClearMode.
         *
         * If AutoClear is enabled on this RenderTarget, the ClearMode will be
         *  used by the Renderer2D::RenderAllCameras to clear the entire
         *  RenderTarget before rendering the first Camera2D. As opposed to the
         *  AutoSwap flag, the AutoClear does not invalidate Camera clearing setting.
         *
         *  @param clearMode Clear Mode to be set.
         */
        CANDERA_DEPRECATED_3_3_0("Please use a camera with clearing enabled instead.",
            void SetClearMode(const SharedClearMode2D::SharedPointer& clearMode)
        );

        /**
         * @brief Get the RenderTarget2DClearMode.
         *
         * @return associated RenderTarget2DClearMode.
         */
        CANDERA_DEPRECATED_3_3_0("Please use a camera with clearing enabled instead.",
            SharedClearMode2D::SharedPointer GetSharedClearMode() const
        );

    private:
        friend class Renderer2D;

        SharedClearMode2D::SharedPointer m_clearMode;
};

/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif // CANDERAPLATFORM_RENDERTARGET_2D_H
