//########################################################################
// (C) Candera GmbH
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Candera GmbH.
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_IMAGE_SOURCE_3D)
    #define CANDERAPLATFORM_IMAGE_SOURCE_3D

#include <Candera/EngineBase/Common/BaseStringBufferAppenders.h>
#include <CanderaPlatform/Device/Common/Base/ImageSource.h>

#ifdef CANDERA_3D_ENABLED
    #include <Candera/Engine3D/Core/TextureImage.h>
#else
    #include <CanderaPlatform/Device/Common/Stubs/DummyCandera3D.h>
#endif

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

/**
 *  @brief ImageSource3D can be used as texture inside Candera 3D API as it provides the name (by open gl terms) to a texture
 *  object.
 */
class ImageSource3D : public ImageSource {
    public:
        ImageSource3D():m_target(TextureImage::Texture2D) {}

        virtual ~ImageSource3D() {}

        /**
         *  Get the open GL texture object name.
         *
         *  @return     OpenGL texture object name.
         */
        virtual Handle GetVideoMemoryHandle() const = 0;

        /**
         *  Specifies whether MipMapping for this object is enabled.
         *
         *  @return     True if MipMapping is enabled, False otherwise.
         */
        virtual bool IsMipMappingEnabled() const = 0;

        /**
         * Specifies whether this object has a 2D or cube map texture as target.
         * @return  TextureTarget of this ImageSource3D.
         */
        virtual TextureImage::TextureTargetType GetTextureTarget() const { return m_target; }

protected:

         /**
         * Specifies whether this object has a 2D or cube map texture as target.
         * @param target    TextureTarget of this ImageSource3D.
         */
        virtual void SetTextureTarget(TextureImage::TextureTargetType target) { m_target = target; }

private:
        TextureImage::TextureTargetType m_target;
};

/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_IMAGE_SOURCE_3D
