//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_META_INFO_H)
    #define CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_META_INFO_H

#include <Candera/Environment.h>
#include <Candera/System/MetaInfo/MetaInfo.h>
#include <Candera/System/MetaInfo/PublicMacros.h>

#include <CanderaPlatform/OS/SerializationPlatform.h>

#include <CanderaPlatform/Device/Common/Base/DeviceMetaInfo.h>

namespace Candera {
    namespace MetaInfo {
        typedef DevicePropertyMetaInfo GraphicDeviceUnitPropertyMetaInfo;
        typedef DeviceMetaInfo GraphicDeviceUnitMetaInfo;
    } //namespace MetaInfo
} //namespace Candera


/** Opens a gdu definition section. @see CdaDeviceMetaInfoHostDef */
#define CdaGduDef(typeName) \
    CdaDeviceMetaInfoHostDef(typeName) \
    _CdaInheritedPropertyBase(Candera::GraphicDeviceUnit, MetaInfo)

/** Opens a gdu definition section. @see CdaDeviceMetaInfoFakeHostDef */
#define CdaForeignGduDef(typeName) \
    CdaDeviceMetaInfoFakeHostDef(typeName) \
    typedef Candera::MetaInfo::NullAggregatable<Candera::MetaInfo::DevicePropertyMetaInfo> PredefinedBaseTypeImportedProperties; \
    typedef void PredefinedBaseType;

/** Closes a gdu definition section. @see CdaDeviceMetaInfoHostDefEnd */
#define CdaGduDefEnd() \
    CdaDeviceMetaInfoHostDefEnd()

/** Opens a properties definition section within a gdu definition section. @see CdaDeviceMetaInfoHostProperties */
#define CdaGduProperties() \
    CdaDeviceMetaInfoHostProperties() \
    _CdaPredefinedBaseClassImportProperties(MetaInfo)

/** Closes a properties definition section within a gdu definition section. @see CdaDeviceMetaInfoHostPropertiesEnd */
#define CdaGduPropertiesEnd() \
    CdaDeviceMetaInfoHostPropertiesEnd()

/** Opens a property definition section within a properties definition section. @see CdaDeviceMetaInfoHostProperty */
#define CdaGduProperty(name, type, getter, setter) \
    CdaDeviceMetaInfoHostProperty(name, type, getter, setter)

/** Closes a property definition section within a properties definition section. @see CdaDeviceMetaInfoHostPropertiesEnd */
#define CdaGduPropertyEnd() \
    CdaDeviceMetaInfoHostPropertyEnd()
    
/** Imports properties from some member. @see CdaDeviceMetaInfoHostImportProperties */
#define CdaGduImportProperties(name, type, fieldName) \
    CdaDeviceMetaInfoHostImportProperties(name, type, fieldName)

/** Imports properties from some base class. @see CdaDeviceMetaInfoHostImportBaseClassProperties */
#define CdaGduImportBaseClassProperties(name, type) \
    CdaDeviceMetaInfoHostImportBaseClassProperties(name, type)

#endif  // CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_META_INFO_H
