//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_ATTRIBUTES_H)
    #define CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_ATTRIBUTES_H

#include <Candera/Environment.h>

namespace Candera {

    /** @addtogroup CommonDevice
     *  @{
     */

    /**
     *  GraphicDeviceUnitAttributes
     *  GduAttributeListEnd,                    > Value that should be used to mark the end of a configuration attribute list.
     *  GduWidthAttr,                           > Width attribute.
     *  GduHeightAttr,                          > Height attribute.
     *  GduColorFormatBegin,                    > Mark for first ColorFormat attribute.
     *  GduRedSizeAttr = GduColorFormatBegin,   > Minimum number of bits for the red channel.
     *  GduGreenSizeAttr,                       > Minimum number of bits for the green channel.
     *  GduBlueSizeAttr,                        > Minimum number of bits for the blue channel.
     *  GduAlphaSizeAttr,                       > Minimum number of bits for the alpha channel.
     *  GduColorFormatEnd,                      > Mark for the end of ColorFormat attributes.
     *  GduGenericAttributesEnd                 > First value that should be used by custom platforms to define platform specific configuration attributes.
     */
    enum GraphicDeviceUnitAttributes {
        GduAttributeListEnd,                    ///<Value that should be used to mark the end of a configuration attribute list.

        //Generic Size attributes
        GduWidthAttr,                           ///<Width attribute.
        GduHeightAttr,                          ///<Height attribute.

        //Generic ColorFormat attributes
        GduColorFormatBegin,                    ///<Mark for first ColorFormat attribute.
        GduRedSizeAttr = GduColorFormatBegin,   ///<Minimum number of bits for the red channel.
        GduGreenSizeAttr,                       ///<Minimum number of bits for the green channel.
        GduBlueSizeAttr,                        ///<Minimum number of bits for the blue channel.
        GduAlphaSizeAttr,                       ///<Minimum number of bits for the alpha channel.
        GduColorFormatEnd,                      ///<Mark for the end of ColorFormat attributes.
      
        GduGenericAttributesEnd                 ///<First value that should be used by custom platforms to define platform specific configuration attributes.
    };
    
/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_GRAPHIC_DEVICE_UNIT_ATTRIBUTES_H
