//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GraphicDeviceUnit.h"
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaPlatformDevice);

    const ImageSource2D* GraphicDeviceUnit::ToImageSource2D(Int index) const
    {
        return const_cast<GraphicDeviceUnit*>(this)->ToImageSource2D(index);
    }
    const RenderTarget2D* GraphicDeviceUnit::ToRenderTarget2D(Int index) const
    {
        return const_cast<GraphicDeviceUnit*>(this)->ToRenderTarget2D(index);
    }
    const ImageSource3D* GraphicDeviceUnit::ToImageSource3D(Int index) const
    {
        return const_cast<GraphicDeviceUnit*>(this)->ToImageSource3D(index);
    }
    const RenderTarget3D* GraphicDeviceUnit::ToRenderTarget3D(Int index) const
    {
        return const_cast<GraphicDeviceUnit*>(this)->ToRenderTarget3D(index);
    }
    const Window* GraphicDeviceUnit::ToWindow() const
    {
        return const_cast<GraphicDeviceUnit*>(this)->ToWindow();
    }

    bool GraphicDeviceUnit::IsUploadPresequisiteFullfiled() const
    {
        CdaPropertyMetaInfoErrorType propertyValidity = CdaValidValue();

        const Candera::MetaInfo::GraphicDeviceUnitMetaInfo* metaInfo = DevicePackageDescriptor::GetMetaInformation(GetUnitType());
        if (metaInfo != 0) {
            for (Int32 index = 0; index < metaInfo->GetItemCount(); ++index) {
                const Candera::MetaInfo::GraphicDeviceUnitPropertyMetaInfo* propertyMetaInfo = metaInfo->GetItem(index);
                if (propertyMetaInfo != 0) {
                    if (propertyMetaInfo->GetValueValidity(this, propertyValidity) == Candera::MetaInfo::PropertyMetaInfoBase::InvalidValue) {
                        FEATSTD_LOG_ERROR("Upload precondition is not fulfilled for GraphicDeviceUnit:\"%s\". %s", (GetName() == 0) ? "" : GetName(), propertyValidity);
                        return false;
                    }
                }
            }
        }

        return true;
    }

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetAutoSwapEnabled(bool enabled)
    {
        if (ToRenderTarget3D() != 0) {
            ToRenderTarget3D()->SetAutoSwapEnabled(enabled);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    bool GraphicDeviceUnit::IsAutoSwapEnabled() const
    {
        if (ToRenderTarget3D() != 0) {
            return ToRenderTarget3D()->IsAutoSwapEnabled();
        }
        return false;
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetAutoSwap2DEnabled(bool enabled)
    {
        if (ToRenderTarget2D() != 0) {
            ToRenderTarget2D()->SetAutoSwapEnabled(enabled);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    bool GraphicDeviceUnit::IsAutoSwap2DEnabled() const
    {
        if (ToRenderTarget2D() != 0) {
            return ToRenderTarget2D()->IsAutoSwapEnabled();
        }
        return false;
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetAutoClearEnabled(bool enabled)
    {
        if (ToRenderTarget3D() != 0) {
            ToRenderTarget3D()->SetAutoClearEnabled(enabled);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    bool GraphicDeviceUnit::IsAutoClearEnabled() const
    {
        if (ToRenderTarget3D() != 0) {
            return ToRenderTarget3D()->IsAutoClearEnabled();
        }
        return false;
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetAutoClear2DEnabled(bool enabled)
    {
        if (ToRenderTarget2D() != 0) {
            ToRenderTarget2D()->SetAutoClearEnabled(enabled);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    bool GraphicDeviceUnit::IsAutoClear2DEnabled() const
    {
        if (ToRenderTarget2D() != 0) {
            return ToRenderTarget2D()->IsAutoClearEnabled();
        }
        return false;
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetClearMode(SharedClearMode::SharedPointer clearMode)
    {
        if (ToRenderTarget3D() != 0) {
            ToRenderTarget3D()->SetClearMode(clearMode);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    SharedClearMode::SharedPointer GraphicDeviceUnit::GetClearMode() const
    {
        if (ToRenderTarget3D() != 0) {
            return ToRenderTarget3D()->GetSharedClearMode();
        }
        return SharedClearMode::SharedPointer();
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    void GraphicDeviceUnit::SetClearMode2D(SharedClearMode2D::SharedPointer clearMode)
    {
        if (ToRenderTarget2D() != 0) {
            ToRenderTarget2D()->SetClearMode(clearMode);
        }
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

    FEATSTD_SUPPRESS_DEPRECATION_WARNING_BEGIN()
    SharedClearMode2D::SharedPointer GraphicDeviceUnit::GetClearMode2D() const
    {
        if (ToRenderTarget2D() != 0) {
            return ToRenderTarget2D()->GetSharedClearMode();
        }
        return SharedClearMode2D::SharedPointer();
    }
    FEATSTD_SUPPRESS_DEPRECATION_WARNING_END()

}   // namespace Candera
