//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_GPU_PERFORMANCE_DATA_PROVIDER_H)
    #define CANDERAPLATFORM_GPU_PERFORMANCE_DATA_PROVIDER_H

#include <CanderaPlatform/OS/CanderaTypes.h>

namespace Candera {

    struct GpuPerformanceData {
    
        struct WiData {
            static const UInt32 InvalidCount = 0xFFFFFFFF;
            UInt32 kickCount;
            UInt32 submitCount;
        };

        struct GpuData {
            static const UInt8 InvalidLoad       = 255;
            static const UInt32 InvalidIdleTime  = 0xFFFFFFFF;
            static const UInt32 InvalidPeriod    = 0xFFFFFFFF;
            static const UInt32 InvalidIdleCount = 0xFFFFFFFF;
            UInt32 period;
            UInt32 idleTime;
            UInt32 idleCount;
            UInt8 load;
        };

        WiData wi2D;
        GpuData pixEng;
        WiData wi3D;
        GpuData gpu;
    };


    class GpuPerformanceDataProvider {
        public:
            virtual bool GetPerformanceData(GpuPerformanceData& performanceData) = 0;
    };

}   // namespace Candera

#endif  // CANDERAPLATFORM_GPU_PERFORMANCE_DATA_PROVIDER_H
