//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_DISPLAY_ORIENTATION_H)
#define CANDERAPLATFORM_DISPLAY_ORIENTATION_H
namespace Candera {
/** @addtogroup CommonDevice
 *  @{
 */
/**
 *  @brief Orientation of the display for warping.
 */
class DisplayOrientation {
public:
    enum Enum {
        Unchanged                        = 0, /**< The display is not flipped. */
        HorizontallyFlipped              = 1, /**< The display is flipped horizontally. */
        VerticallyFlipped                = 2, /**< The display is flipped vertically. */
        VerticallyAndHorizontallyFlipped = 3  /**< The display is flipped vertically and horizontally. */    
    };
};
/** @}*/ //end of CommonDevice
}   // namespace Candera

#endif  // !defined(CANDERAPLATFORM_DISPLAY_ORIENTATION_H)
