//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Display.h"
#include <CanderaPlatform/Device/Common/Base/DevicePackageTrace.h>
#include <CanderaPlatform/Device/Common/Base/DevicePackageDescriptor.h>

namespace Candera
{

ContextResourcePool* Display::GetDefaultContextResourcePool() const
{
    return ContextResourcePool::GetContextResourcePool(
        DevicePackageDescriptor::GetDisplayContextResourcePoolIndex(
            m_displayId));
}

bool Display::SetWarpingEnabled(bool isEnabled) 
{ 
    if (GetNativeHandle() != 0) { 
        return false; 
    } 
    m_warpingProperties.SetWarpingEnabled(isEnabled);
    return true; 
}

Display::Display(Int displayId) :
    m_isUploaded(false),
    m_pool(0), 
    m_fallbackPool(&ContextResourcePool::GetDefault()),
    m_displayId(displayId)
{
}

bool Display::Upload(const CommonSettings& settings)
{
    m_isUploaded = UploadInternal(settings);

    return m_isUploaded;
}

void Display::Unload()
{
    if (m_isUploaded) {
        UnloadInternal();
        m_isUploaded = false;
    }
}

namespace Internal {

ContextResourcePool* DisplayAccess::GetUserContextResourcePool(const Display* display)
{
    return display->m_pool;
}
bool DisplayAccess::SetUserContextResourcePool(Display* display, ContextResourcePool* pool)
{
    if (display == 0) {
        return false;
    }
    if (display->IsUploaded()) {
        CANDERA_DEVICE_LOG_WARN("Can not set ContextResource pool on uploaded display!");
        return false;
    }

    display->m_pool = (pool != 0) ?  pool : &ContextResourcePool::GetActive(); 

    return true;
}
ContextResourcePool* DisplayAccess::GetFallbackContextResourcePool(const Display* display)
{
    return display->m_fallbackPool;
}
ContextResourcePool* DisplayAccess::GetEffectiveContextResourcePool(const Display* display)
{
    ContextResourcePool* pool = GetUserContextResourcePool(display);
    if (pool == 0) {
        pool = display->GetDefaultContextResourcePool();
        if (pool == 0) {
            pool = GetFallbackContextResourcePool(display);
        }
    }
    return pool;
}

}   //namespace Internal
}   // namespace Candera
