//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "DevicePackageDescriptor.h"
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>

namespace Candera
{
    bool DevicePackageDescriptor::GetCurrentRenderDevice3DCapabilities(const RenderDevice3DCapabilities*& capabilities)
    {
        static RenderDevice3DCapabilities::ViewportSize viewportSize = {0, 0};
        if ((viewportSize.width == 0) && (viewportSize.height == 0)) {
            RenderDevice::GetMaxViewportSizeSupportedByDevice(viewportSize.width, viewportSize.height);
        }
        static UInt maxTextureSize                  = RenderDevice::GetMaxTextureSizeSupportedByDevice();
        static UInt8 maxCombinedTextureImageUnits   = static_cast<UInt8>(RenderDevice::GetMaxCombinedTextureUnitsSupportedByDevice());
        static UInt32 maxCubeMapTextureSize         = RenderDevice::GetMaxCubeMapTextureSizeSupportedByDevice();
        static UInt16 maxFragmentUniformVectors     = static_cast<UInt16>(RenderDevice::GetMaxFragmentUniformVectorsSupportedByDevice());
        static UInt maxRenderbufferSize             = RenderDevice::GetMaxRenderBufferSizeSupportedByDevice();    
        static UInt8 maxTextureImageUnits           = static_cast<UInt8>(RenderDevice::GetMaxTextureUnitsSupportedByDevice()); 
        static UInt8 maxVaryingVectors              = static_cast<UInt8>(RenderDevice::GetMaxVaryingVectorsSupportedByDevice());
        static UInt8 maxVertexAttribs               = static_cast<UInt8>(RenderDevice::GetMaxVertexAttribsSupportedByDevice());
        static UInt8 maxVertexTextureImageUnits     = static_cast<UInt8>(RenderDevice::GetMaxVertexTextureUnitsSupportedByDevice());
        static UInt16 maxVertexUniformVectors       = static_cast<UInt16>(RenderDevice::GetMaxVertexUniformVectorsSupportedByDevice());
        static UInt32 maxIndexElementIndex          = RenderDevice::GetMaxIndexElementSupportedByDevice();
        static const Char* apiVersion               = RenderDevice::GetDeviceInfo(RenderDevice::ApiVersionInfo);
        static bool isDxtCompressionSupported       = RenderDevice::IsDxtCompressionSupportedByDevice();

        static const RenderDevice3DCapabilities caps = {
            maxTextureSize,                 // UInt32 m_maxTextureSize
            maxCombinedTextureImageUnits,   // UInt8 m_maxCombinedTextureImageUnits;
            maxCubeMapTextureSize,          // UInt32 m_maxCubeMapTextureSize;
            maxFragmentUniformVectors,      // UInt16 m_maxFragmentUniformVectors;
            maxRenderbufferSize,            // UInt32 m_maxRenderbufferSize;
            maxTextureImageUnits,           // UInt8 m_maxTextureImageUnits; 
            maxVaryingVectors,              // UInt8 m_maxVaryingVectors;
            maxVertexAttribs,               // UInt8 m_maxVertexAttribs; 
            maxVertexTextureImageUnits,     // UInt8 m_maxVertexTextureImageUnits;
            maxVertexUniformVectors,        // UInt16 m_maxVertexUniformVectors;
            viewportSize,                   // ViewportDims m_maxViewportDims;
            maxIndexElementIndex,           // UInt32 m_maxElementIndex;
            apiVersion,                     // const Char* m_rendererAPI
            isDxtCompressionSupported       //bool m_isDxtCompressionSupported
        };

        capabilities = &caps;

        return true;
    }

    // Run next snippet on target to find out the target capabilities.
    //const DevicePackageDescriptor::RenderDevice3DCapabilities* caps = 0;
    //if (DevicePackageDescriptor::GetCurrentRenderDevice3DCapabilities(caps)) {
    //    printf(" static const DevicePackageDescriptor::RenderDevice3DCapabilities s_renderDeviceCapabilities = {\n");
    //    printf("    /*UInt32 m_maxTextureSize                */ %d,\n", caps->m_maxTextureSize);
    //    printf("    /*UInt8 m_maxCombinedTextureImageUnits;  */ %d,\n", caps->m_maxCombinedTextureImageUnits);
    //    printf("    /*UInt32 m_maxCubeMapTextureSize;        */ %d,\n", caps->m_maxCubeMapTextureSize);
    //    printf("    /*UInt16 m_maxFragmentUniformVectors;    */ %d,\n", caps->m_maxFragmentUniformVectors);
    //    printf("    /*UInt32 m_maxRenderbufferSize;          */ %d,\n", caps->m_maxRenderBufferSize);
    //    printf("    /*UInt8 m_maxTextureImageUnits;          */ %d,\n", caps->m_maxTextureImageUnits);
    //    printf("    /*UInt8 m_maxVaryingVectors;             */ %d,\n", caps->m_maxVaryingVectors);
    //    printf("    /*UInt8 m_maxVertexAttributes            */ %d,\n", caps->m_maxVertexAttributes);
    //    printf("    /*UInt8 m_maxVertexTextureImageUnits;    */ %d,\n", caps->m_maxVertexTextureImageUnits);
    //    printf("    /*UInt16 m_maxVertexUniformVectors;      */ %d,\n", caps->m_maxVertexUniformVectors);
    //    printf("    /*ViewportDims m_maxViewportDims;        */ { %d, \%d},\n", caps->m_maxViewportSize.width, caps->m_maxViewportSize.height);
    //    printf("    /*UInt32 m_maxElementIndex;              */ 0x%x,\n", caps->m_maxElementIndex);
    //    printf("    /*const Char* m_rendererAPI              */ \"%s\"\n", caps->m_rendererAPI);
    //    printf("};\n");
    //}

} //namespace Candera


