//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_DEVICE_META_INFO_HOST_H)
    #define CANDERAPLATFORM_DEVICE_META_INFO_HOST_H

#include <Candera/Environment.h>

namespace Candera {

    /**
     * @brief DeviceMetaInfoHost is an interface used for attaching meta-information to device package objects.
     */
    class DeviceMetaInfoHost {
        public:
            /**
             * Apply the current properties set via meta-info interface to the device object.
             */
            virtual void ApplyChanges() {};
            
        protected:
            DeviceMetaInfoHost() {}
            DeviceMetaInfoHost(const DeviceMetaInfoHost&) {}
            
            virtual ~DeviceMetaInfoHost() {}
    };
} //namespace Candera

#endif  // CANDERAPLATFORM_DEVICE_META_INFO_HOST_H
