//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZABLETEXTBASE_H)
#define CANDERA_GLOBALIZATION_LOCALIZABLETEXTBASE_H

#include <CanderaGlobalization/Localizable.h>

namespace Candera { namespace Globalization { namespace Internal {
typedef SizeType TextId;
/// @addtogroup CanderaGlobalizationLocalizable
/// @{
/**
    *  Base class for translatable text.
    */
class LocalizableTextBase : public Localizable {
    FEATSTD_TYPEDEF_BASE(Localizable);

    public:
        /**
            *  Constructor
            *  @param  id              The unique identifier for the text.
            *  @param  defaultString   Defines the initial string for the text, which is uses as long as no cultures
            *                          and its corresponding translation tables are available.
            *                          As soon as there is a translation available for that string ID, the initial string is lost.
            */
        LocalizableTextBase(Id id, const TChar* defaultString = 0);

        /**
            *  Destructor
            */
        virtual ~LocalizableTextBase();

        /**
            *  Retrieves the translated string regarding to the current culture language.
            *  @return         The translated text.
            */
        const TChar* GetCString() const;

#ifdef FEATSTD_THREADSAFETY_ENABLED
        FeatStd::Internal::CriticalSection &GetCriticalSection() const;
#endif

        bool HasChanged() const;

    protected:
        mutable const TChar* m_cachedString; // pointer to the cached string to display

        virtual void OnIdChanged(Id id);
        virtual void OnCultureChanged(const Culture& culture);

        /**
            *  Has to set m_cachedString.
            */
        virtual void ResolveString() const = 0;

};

/// @}
}}}   // namespace Candera::Globalization::Internal

#endif  // CANDERA_GLOBALIZATION_LOCALIZABLETEXTBASE_H
