//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LocalizableTextBase.h"

#ifdef FEATSTD_THREADSAFETY_ENABLED
#include <FeatStd/Platform/CriticalSectionLocker.h>
#include <FeatStd/Util/StaticObject.h>
#endif

namespace Candera { namespace Globalization { namespace Internal {
/******************************************************************************
 *  Constructor
 ******************************************************************************/
LocalizableTextBase::LocalizableTextBase(Localizable::Id id, const TChar* defaultString /* = 0 */) :
    Base(id),
    m_cachedString(defaultString)
{
}

/******************************************************************************
 *  Destructor
 ******************************************************************************/
LocalizableTextBase::~LocalizableTextBase()
{
    m_cachedString = 0;
}

#ifdef FEATSTD_THREADSAFETY_ENABLED

static FeatStd::Internal::CriticalSection& LocalizableTextBaseCriticalSection()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(FeatStd::Internal::CriticalSection, s_localizableTextBaseCriticalSection);
    return s_localizableTextBaseCriticalSection;
}

static FeatStd::Internal::CriticalSection& s_forceInitLocalizableTextBaseCriticalSection = LocalizableTextBaseCriticalSection();

/******************************************************************************
*  HasChanged
******************************************************************************/
FeatStd::Internal::CriticalSection &LocalizableTextBase::GetCriticalSection() const
{
    return LocalizableTextBaseCriticalSection();
}

#endif

/******************************************************************************
*  HasChanged
******************************************************************************/
bool LocalizableTextBase::HasChanged() const {
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
    return m_cachedString == 0;
}

/******************************************************************************
 *  OnIdChanged
 ******************************************************************************/
void LocalizableTextBase::OnIdChanged(Id /*id*/)
{
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
    m_cachedString = 0;
}

/******************************************************************************
 *  OnCultureChanged
 ******************************************************************************/
void LocalizableTextBase::OnCultureChanged(const Culture& /*culture*/)
{
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
    m_cachedString = 0;
}

/******************************************************************************
 *  GetString
 ******************************************************************************/
const TChar* LocalizableTextBase::GetCString() const
{
#ifdef FEATSTD_THREADSAFETY_ENABLED
    FeatStd::Internal::CriticalSectionLocker lock(&GetCriticalSection());
#endif
    if (m_cachedString == 0) {
        ResolveString();
    }
    return m_cachedString;
}
}}}   // namespace Candera::Globalization::Internal
