//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZABLESTRINGFACTORY_H)
#define CANDERA_GLOBALIZATION_LOCALIZABLESTRINGFACTORY_H

#include <Candera/Environment.h>
#include <FeatStd/Util/StringDataFactory.h>

namespace Candera { namespace Globalization { namespace Internal {
    class LocalizableStringDataBase;

    class LocalizableStringDataFactory : public FeatStd::Internal::StringDataFactory {
        FEATSTD_TYPEDEF_BASE(FeatStd::Internal::StringDataFactory);

    public:
        FEATSTD_LINT_NEXT_EXPRESSION(1511, "disambiguity with FeatStd::Internal::StringDataFactory::GetInstance remains in place to preserve interface compatibility.")
        static LocalizableStringDataFactory& GetInstance();

        //only partially overridden
        using FeatStd::Internal::StringDataFactory::CreateLocalizableStringData;
        virtual FeatStd::Internal::StringDataBase* CreateLocalizableStringData(SizeType id, const TChar* defaultString) const;

        virtual ~LocalizableStringDataFactory() {}

    private:
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1516, FeatStd::Internal::StringDataFactory::cPriority, CANDERA_LINT_REASON_EXPLICITHIDING)
        static const UInt8 cPriority = 2;

        LocalizableStringDataFactory();

        LocalizableStringDataBase* CreateSimpleStringData(SizeType id, const TChar* defaultString = 0) const;
        LocalizableStringDataBase* CreateParameterizedStringData(SizeType id) const;
    };
}}} // namespace Candera::Globalization::Internal

#endif  // CANDERA_GLOBALIZATION_LOCALIZABLESTRINGFACTORY_H
