//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LocalizableStringDataFactory.h"
#include <CanderaGlobalization/LocalizableStringData.h>
#include <CanderaGlobalization/ParameterizedLocalizableStringDataFactory.h>
#include <CanderaGlobalization/GlobalizationCultureManager.h>
#include <CanderaGlobalization/Localizer.h>
#include <FeatStd/Util/StaticObject.h>

namespace Candera { namespace Globalization { namespace Internal {
/******************************************************************************
 *  GetInstance
 ******************************************************************************/
LocalizableStringDataFactory& LocalizableStringDataFactory::GetInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(LocalizableStringDataFactory, s_localizableStringFactory);
    return s_localizableStringFactory;
}

static LocalizableStringDataFactory& s_forceInitInstance = LocalizableStringDataFactory::GetInstance();

FEATSTD_LINT_SYMBOL(1938, Candera::Globalization::Internal::LocalizableStringDataFactory::LocalizableStringDataFactory, "access to global constant data only")

/******************************************************************************
 *  Constructor
 ******************************************************************************/
LocalizableStringDataFactory::LocalizableStringDataFactory() :
    Base(cPriority)
{ 
}

/******************************************************************************
 *  CreateTranslatableStrData
 ******************************************************************************/
FeatStd::Internal::StringDataBase* LocalizableStringDataFactory::CreateLocalizableStringData(SizeType id, const TChar* defaultString) const
{
    LocalizableStringDataBase* strData = 0;
    Localizer::SharedPointer localizer = GlobalizationCultureManager::GetInstance().GetLocalizer();

    FEATSTD_UNUSED(defaultString);

    if (!localizer.PointsToNull()) {
        Localizer::TextType textType = localizer->GetTextType(id);

        switch (textType) {
            case Localizer::SimpleText:
                strData = CreateSimpleStringData(id);
                break;

            case Localizer::ParameterizedText:
                strData = CreateParameterizedStringData(id);
                break;

            // if the id is not found in the language pack but the default text is set, we create a SimpleText with the default text
            case Localizer::_undefined:
                strData = CreateSimpleStringData(id);
                break;
            default:
                break;
        }
    }
    else {
        strData = CreateSimpleStringData(id);
    }

    return strData;
}

/******************************************************************************
 *  CreateSimpleStringData
 ******************************************************************************/
LocalizableStringDataBase* LocalizableStringDataFactory::CreateSimpleStringData(SizeType id, const TChar* defaultString/* = 0*/) const
{
    return LocalizableStringData::Create(id, defaultString);
}

/******************************************************************************
 *  CreateParameterizedStringData
 ******************************************************************************/
LocalizableStringDataBase* LocalizableStringDataFactory::CreateParameterizedStringData(SizeType id) const
{
     return ParameterizedLocalizableStringDataFactory::GetInstance().CreateStringData(id);
}
}}}   // namespace Candera::Globalization::Internal
