//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATA_H)
    #define CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATA_H

#include <CanderaGlobalization/LocalizableStringDataBase.h>

#include <cstring>

namespace Candera { namespace Globalization { namespace Internal {
/// @addtogroup CanderaGlobalizationLocalizable
/// @{

/**
    *  Localizable string data object.
    */
class LocalizableStringData : public LocalizableStringDataBase {
    FEATSTD_TYPEDEF_BASE(LocalizableStringDataBase);

    public:

        /**
            *  Constructor
            */
        LocalizableStringData(){};

        /**
            *  Destructor
            */
        virtual ~LocalizableStringData();

        /**
            * Create method which allocates contiguous memory for object and it's memebers
            * @param  id              The unique identifier for the text.
            * @param  defaultString   Defines the initial string for the text, which is uses as long as no cultures
            *                          and its corresponding translation tables are available.
            *                          As soon as there is a translation available for that string ID, the initial string is lost.
            */
        static LocalizableStringData* Create(Localizable::Id id, const TChar* defaultString = 0);
        virtual void Destroy();

    private:
        LocalizableStringData(const LocalizableStringData&);
        LocalizableStringData& operator=(const LocalizableStringData&);
};

/// @}
}}}   // namespace Candera::Globalization::Internal
#endif  // CANDERA_GLOBALIZATION_LOCALIZABLESTRINGDATA_H
