//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEFAULT_LOCALIZER_H)
#define CANDERA_DEFAULT_LOCALIZER_H

#include <CanderaGlobalization/Localizer.h>
#include <CanderaGlobalization/LanguagePack.h>

namespace Candera {
class AssetProvider;

namespace Globalization { namespace Internal {
/// @addtogroup CanderaGlobalizationCulture
/// @{
/**
    *  Implements a Localizer that gets the necessary language packs, depending on the currently set culture, from the default asset provider.
    */
class DefaultLocalizer : public Localizer {
    FEATSTD_TYPEDEF_BASE(Globalization::Localizer);

    public:

        FEATSTD_TYPEDEF_SHARED_POINTER(DefaultLocalizer);

        /** Retrieves the singleton instance of this class.
            *  @return     A reference to the singleton instance of this class.
            */
        static DefaultLocalizer& GetInstance();

        void SetAssetProvider(AssetProvider* assetProvider) { m_assetProvider = assetProvider; }

        // see Localizer::SetCurrentCulture
        virtual void SetCurrentCulture(Culture::SharedPointer culture);

        // see Localizer::GetTextBaseString
        virtual const TChar* GetTextBaseString(LocalizableId id) const;

        // see Localizer::GetTextType
        virtual TextType GetTextType(LocalizableId id) const;

    protected:

    private:
        Globalization::LanguagePack::SharedPointer m_languagePack;
        AssetProvider* m_assetProvider;

        // implemented as singleton
        DefaultLocalizer();
        virtual ~DefaultLocalizer();

        /**
        *  Creates an instance of this class.
        *  @return     Shared pointer to the created object.
        */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
};
/// @}
}}}   // namespace Candera::Globalization::Internal
#endif  // CANDERA_DEFAULT_LOCALIZER_H
