//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLOBALIZATION_FORMATTER_H)
#define CANDERA_GLOBALIZATION_FORMATTER_H

#include <Candera/Environment.h>

namespace Courier {
    class DataItemValue;
}

namespace Candera { namespace Globalization {
/// @addtogroup CanderaGlobalizationLocalizable
/// @{
class Value;

/**
    *  Base class for dynamic text parameter formatters.
    */
class Formatter {
    public:
        Formatter();
        virtual ~Formatter();

        /**
            *  This method is called from DynamicText::ResolveString() to convert a paramter type into a string.
            *  @param  value        Pointer to the data; has to be casted to the correct type.
            *  @param  dst         Pointer to the destination string where the output has to be placed.
            *  @param  maxLength   Maximal amount of characters which are allowed to write to dst.
            *  @return             The count of character which have been written to dst.
            */
        virtual UInt16 Format(const Courier::DataItemValue& value, TChar* dst, UInt16 maxLength) = 0;

    protected:

    private:
};

class StringFormatter : public Formatter {
    public:
        StringFormatter() {}
        virtual ~StringFormatter() {}

        virtual UInt16 Format(const Courier::DataItemValue& value, TChar* dst, UInt16 maxLength);
};

/**
    *  Int32Formatter
    */
class Int32Formatter : public Formatter {
    FEATSTD_TYPEDEF_BASE(Formatter);

    public:
        Int32Formatter();
        virtual ~Int32Formatter();

        void SetFormatString(const Char* formatString) { m_formatString = formatString; }

        virtual UInt16 Format(const Courier::DataItemValue& value, TChar* dst, UInt16 maxLength);

    protected:
    private:
        const Char* m_formatString;
};

/**
    *  FloatFormatter
    */
class FloatFormatter : public Formatter {
    FEATSTD_TYPEDEF_BASE(Formatter);

    public:
        FloatFormatter();
        virtual ~FloatFormatter();

        void SetFormatString(const Char* formatString) { m_formatString = formatString; }

        virtual UInt16 Format(const Courier::DataItemValue& value, TChar* dst, UInt16 maxLength);

    protected:

    private:
        const Char* m_formatString;
};

/**
    *  BoolFormatter
    */
class BoolFormatter : public Formatter {
    FEATSTD_TYPEDEF_BASE(Formatter);

    public:
        BoolFormatter();
        virtual ~BoolFormatter();

        void SetTrueString(const TChar* trueString) { m_trueString = trueString; }
        void SetFalseString(const TChar* falseString) { m_falseString = falseString; }

        virtual UInt16 Format(const Courier::DataItemValue& value, TChar* dst, UInt16 maxLength);

    protected:

    private:
        const TChar* m_trueString;
        const TChar* m_falseString;
};
/// @}
}}
#endif  // CANDERA_GLOBALIZATION_FORMATTER_H
