//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_TOUCH_SESSION_EVENT_H
#define CANDERA_TOUCH_SESSION_EVENT_H

#include <Candera/Environment.h>
#include <CanderaBehavior/Touch/TouchInfo.h>
#include <FeatStd/Event/Event.h>

namespace Candera {

    // the first finger that touches the screen starts the touch session
    // at the begin of the touch session all behaviors have to register for touch handling
    // only registered behaviors will receive the touch events.
    class TouchSessionEvent : public FeatStd::Event
    {
    public:
        FEATSTD_RTTI_DECLARATION();

        enum State
        {
            Begin,
            Drag,
            End,
            Hover
        };

        // touch info of the first finger touching the screen is provided
        TouchSessionEvent(State state, const TouchInfo& touchInfo) :
            m_state(state),
            m_touchInfo(touchInfo)
        {
        }

        const State& GetState() const
        {
            return m_state;
        }

        const TouchInfo& GetTouchInfo() const
        {
            return m_touchInfo;
        }

    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchSessionEvent);
        FEATSTD_MAKE_CLASS_UNCOPYABLE(TouchSessionEvent);
        State m_state;
        const TouchInfo& m_touchInfo;
    };
}
 
#endif //CANDERA_TOUCH_EVENT_H
