//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_TOUCH_SESSION_H
#define CANDERA_TOUCH_SESSION_H

#include <CanderaBehavior/BehaviorBase/Behavior.h>
#include <CanderaBehavior/Touch/TouchInfo.h>

namespace Candera {

    class TouchSession
    {
    public:
        /**
         * UpdateEvent
         */
        class UpdateEvent : public FeatStd::Event
        {
        public:
            FEATSTD_RTTI_DECLARATION();
        
            /**
             * UpdateEvent default constructor.
             */
            UpdateEvent ()
            {
            }
        
            /**
             * UpdateEvent destructor.
             */
            virtual ~UpdateEvent()
            {
            }
        
        private:
            FEATSTD_MAKE_CLASS_UNCOPYABLE(UpdateEvent);
        };
        /**
         * UpdateEventDispatchResult
         */
        class UpdateEventDispatchResult : public Candera::EventDispatchResult
        {
        public:
            FEATSTD_RTTI_DECLARATION();
        
            /**
             * UpdateEventDispatchResult default constructor.
             */
            UpdateEventDispatchResult ()
            {
            }
        
            /**
             * UpdateEventDispatchResult destructor.
             */
            virtual ~UpdateEventDispatchResult()
            {
            }

            /**
            * TODO
            */
            void SetFurtherUpdateRequired()
            {
                m_furtherUpdateRequired = true;
            }

            /**
            * TODO
            */
            bool IsFurtherUpdateRequired() const
            {
                return m_furtherUpdateRequired;
            }

        private:
            FeatStd::Initialized<bool> m_furtherUpdateRequired;
            FEATSTD_MAKE_CLASS_UNCOPYABLE(UpdateEventDispatchResult);
        };
        static TouchSession& GetInstance();
        static void SetInstance(TouchSession* instance);
        FEATSTD_LINT_NEXT_EXPRESSION(1735, "Virtual function does not override a base-class function.")
        virtual void Register(Behavior& behavior, FeatStd::Int mask = static_cast<UInt32>(TouchInfo::Move) | static_cast<UInt32>(TouchInfo::Down) | static_cast<UInt32>(TouchInfo::Up) | static_cast<UInt32>(TouchInfo::Hover));
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Virtual function does not override a base-class function.")
        virtual void Deregister(Behavior& behavior, FeatStd::Int mask = static_cast<UInt32>(TouchInfo::Move) | static_cast<UInt32>(TouchInfo::Down) | static_cast<UInt32>(TouchInfo::Up) | static_cast<UInt32>(TouchInfo::Hover));
        virtual void OnEvent(const FeatStd::Event& event, EventDispatchResult& dispatchResult);
    };

}
 
#endif //CANDERA_TOUCH_SESSION_H
