//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_TOUCH_EVENT_H
#define CANDERA_TOUCH_EVENT_H

#include <Candera/Environment.h>
#include <CanderaBehavior/Touch/TouchInfo.h>
#include <FeatStd/Event/Event.h>

namespace Candera {

    class TouchEvent : public FeatStd::Event
    {
    public:
        FEATSTD_RTTI_DECLARATION();

        TouchEvent(const TouchInfo& touchInfo) :
            m_touchInfo(touchInfo)
        {
        }

        const TouchInfo& GetTouchInfo() const
        {
            return m_touchInfo;
        }

    private:
        FEATSTD_MAKE_CLASS_STATIC(TouchEvent);
        FEATSTD_MAKE_CLASS_UNCOPYABLE(TouchEvent);
        const TouchInfo& m_touchInfo;
    };

}
 
#endif //CANDERA_TOUCH_EVENT_H
