//########################################################################
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaBehavior/Touch/KeyboardModifier.h>

#include <CanderaBehavior/Touch/KeyEvent.h>
#include <FeatStd/Util/StaticObject.h>
#include <FeatStd/Platform/Memory.h>

namespace Candera {

static KeyboardModifier &KeyboardModifierDefaultInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(KeyboardModifier, s_keyboardModifierDefaultInstance);
    return s_keyboardModifierDefaultInstance;
}

static KeyboardModifier* &KeyboardModifierInstance()
{
    FEATSTD_UNSYNCED_STATIC_OBJECT(KeyboardModifier*, s_keyboardModifierInstance, 0);
    return s_keyboardModifierInstance;
}

KeyboardModifier& KeyboardModifier::GetInstance()
{
    KeyboardModifier* instance = KeyboardModifierInstance();
    if (0 == instance) {
        return KeyboardModifierDefaultInstance();
    }
    return *instance;
}

void KeyboardModifier::SetInstance(KeyboardModifier* keyboardModifier)
{
    KeyboardModifierInstance() = keyboardModifier;
}

KeyboardModifier::KeyboardModifier() :
m_modifierBitmask(0)
{
    FeatStd::Internal::Memory::Set(m_modifierCounter, 0, Candera::KeyModifierEnum::Key_Num);
}

KeyboardModifier::~KeyboardModifier()
{
}

Candera::KeyEvent KeyboardModifier::SetModifier(const Candera::KeyEvent& keyEvent)
{
    KeyEvent newKeyEvent = keyEvent;
    if ((keyEvent.m_modifier>=1) && (keyEvent.m_modifier<=3))
    {
        if (keyEvent.m_keyState){
            m_modifierBitmask |= (FeatStd::UInt16(1) << static_cast<FeatStd::UInt16>(keyEvent.m_modifier));
            m_modifierCounter[keyEvent.m_modifier]++;
        }
        else {
            m_modifierCounter[keyEvent.m_modifier]--;
            if (m_modifierCounter[keyEvent.m_modifier]==0)
            {
                m_modifierBitmask &= ~static_cast<FeatStd::UInt16>(FeatStd::UInt16(1) << static_cast<FeatStd::UInt16>(keyEvent.m_modifier));
            }
        }
    }
    else
    {
        if ((keyEvent.m_modifier >= 4) && (keyEvent.m_modifier <= 5) && keyEvent.m_keyState){
            if (0 == (m_modifierBitmask & static_cast<FeatStd::UInt16>(static_cast<FeatStd::UInt16>(1) << static_cast<FeatStd::UInt16>(keyEvent.m_modifier))))
            {
                m_modifierBitmask |= (FeatStd::UInt16(1) << static_cast<FeatStd::UInt16>(keyEvent.m_modifier));
            }
            else
            {
                m_modifierBitmask &= ~ static_cast<FeatStd::UInt16>(FeatStd::UInt16(1) << static_cast<FeatStd::UInt16>(keyEvent.m_modifier));
            }
        }
    }
    
    newKeyEvent.m_modifierBitmask = m_modifierBitmask;
    return newKeyEvent;
}

} // namespace Candera
