//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ProcessValueBehavior.h"

CdaEventDef(Candera::ProcessValueEvent)
    CdaReadableName("Value Processed")
    CdaDescription("This event is sent, whenever a value has been processed and is forwarded for further processing.")
    CdaCategory("Value Processing")
    CdaEventSortOrder((FeatStd::Internal::Limits<FeatStd::Int32>::Min() + 52))
CdaEventDefEnd()

namespace Candera {
    FEATSTD_RTTI_DEFINITION(ProcessValueEvent, FeatStd::Event)
#if defined(CANDERA_LEGACY_BEHAVIORS_ENABLED)
        FEATSTD_RTTI_DEFINITION(ProcessValueResult, EventDispatchResult)
#endif
    CGI_BEHAVIOR_RTTI_DEFINITION(ProcessValueBehavior)
}
