//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_BEHAVIOR_DIRECT_EVENT_DISPATCH_STRATEGY_H
#define CANDERA_BEHAVIOR_DIRECT_EVENT_DISPATCH_STRATEGY_H

#include <CanderaBehavior/BehaviorBase/EventDispatchStrategy.h>

namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    // Direct strategy: only the behaviors of the node will receive the event.
    class DirectEventDispatchStrategy : public EventDispatchStrategy
    {
    public:
        /**
         * Dispatch the event by traversing through all behaviors attached to the given node.
         * @param node The node to start traversing with.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        static void DirectDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);

        /**
         * Calls DirectEventDispatchStrategy::DirectDispatchEvent to traverse through all behaviors attached to the given node.
         * @param node The node to start traversing with.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See EventDispatchStrategy.h)")
        virtual void DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);
    };
/** @} */
}

#endif //CANDERA_BEHAVIOR_DIRECT_EVENT_DISPATCH_STRATEGY_H
