//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DirectEventDispatchStrategy.h"
#include <CanderaBehavior/BehaviorBase/Behavior.h>


namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaBehavior);

#ifdef FEATSTD_LOG_ENABLED
    static const Char* SafeLogString(const Char* s)
    {
        return (0 == s) ? "" : s;
    }
#endif

    void DirectEventDispatchStrategy::DirectDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        FEATSTD_LOG_DEBUG("DirectEventDispatchStrategy: begin dispatching event '%s' on node '%s'!", event.GetDynamicTypeId(), SafeLogString(node.GetName()));
        Behavior* behavior = Behavior::GetFirstBehavior(node);
        while ((!dispatchResult.HasToStopDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && (0 != behavior)) {
            if (IsDirectEventReceiver(behavior) && ((0 == condition) || (condition->Accept(behavior, node, event, dispatchResult)))) {
                OnEvent(behavior, event, dispatchResult);
            }
            behavior = behavior->GetNextBehavior();
        }
        FEATSTD_LOG_DEBUG("DirectEventDispatchStrategy: finished  dispatching event '%s' on node '%s'!", event.GetDynamicTypeId(), SafeLogString(node.GetName()));
    }

    void DirectEventDispatchStrategy::DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        DirectDispatchEvent(node, event, dispatchResult, condition);
    }
}
