//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_BEHAVIOR_BUBBLE_EVENT_DISPATCH_STRATEGY_H
#define CANDERA_BEHAVIOR_BUBBLE_EVENT_DISPATCH_STRATEGY_H

#include <CanderaBehavior/BehaviorBase/EventDispatchStrategy.h>


namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    // Bubble strategy: the event will be dispatched from the node to the root until the dispatching is stopped by a StopAfterDirectDispatching DispatchAction.
    //                  for each node in this chain the Direct dispatch strategy is used.
    class BubbleEventDispatchStrategy : public EventDispatchStrategy
    {
    public:
        typedef void(*DefaultEventHandler)(const FeatStd::Event& event, EventDispatchResult& dispatchResult);

        /**
         * Set a default event handler
         * @param defaultEventHandler The event handler to set.
         */
        static void SetDefaultEventHandler(DefaultEventHandler defaultEventHandler);

        /**
         * Dispatches the event starting with all behaviors attached to the given node, traversing upwards through all parent nodes.
         * @param node The node to start traversing with.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        static void BubbleDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);

        /**
         * Calls BubbleEventDispatchStrategy::BubbleDispatchEvent to traverse from the given node upwards through all parent nodes.
         * @param node The node to start traversing with.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See EventDispatchStrategy.h)")
        virtual void DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);
    };
/** @} */
}

#endif
