//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BubbleEventDispatchStrategy.h"
#include <CanderaBehavior/BehaviorBase/DirectEventDispatchStrategy.h>
#include <CanderaBehavior/BehaviorBase/StateMachineBehavior.h>

namespace Candera {
    static BubbleEventDispatchStrategy::DefaultEventHandler& BubbleEventDispatchStrategyDefaultEventHandler()
    {
        FEATSTD_UNSYNCED_STATIC_OBJECT(BubbleEventDispatchStrategy::DefaultEventHandler, s_bubbleEventDispatchStrategyDefaultEventHandler, 0);
        return s_bubbleEventDispatchStrategyDefaultEventHandler;
    }

    void BubbleEventDispatchStrategy::SetDefaultEventHandler(DefaultEventHandler defaultEventHandler)
    {
        BubbleEventDispatchStrategyDefaultEventHandler() = defaultEventHandler;
    }

    void BubbleEventDispatchStrategy::BubbleDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        AbstractNodePointer current = node;
        while ((!dispatchResult.HasToStopAfterDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && current.IsValid()) {
            DirectEventDispatchStrategy::DirectDispatchEvent(current, event, dispatchResult, condition);
            current = current.GetParent();
        }
        if ((!dispatchResult.HasToStopAfterDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && (0 != StateMachineBehavior::GetGlobalStateMachine())) {
            if ((0 == condition) || (condition->Accept(StateMachineBehavior::GetGlobalStateMachine(), AbstractNodePointer(), event, dispatchResult))) {
                StateMachineBehavior::GetGlobalStateMachine()->DispatchEventLocal(event, dispatchResult);
                if (dispatchResult.IsHandled()) {
                    dispatchResult.StopDispatchingImmediately();
                }
            }
        }
        if ((!dispatchResult.HasToStopAfterDirectDispatching()) && (!dispatchResult.HasToStopDispatchingImmediately()) && (0 != BubbleEventDispatchStrategyDefaultEventHandler())) {
            BubbleEventDispatchStrategyDefaultEventHandler()(event, dispatchResult);
            if (dispatchResult.IsHandled()) {
                dispatchResult.StopDispatchingImmediately();
            }
        }
    }

    void BubbleEventDispatchStrategy::DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition)
    {
        BubbleDispatchEvent(node, event, dispatchResult, condition);
    }
}
