//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#ifndef CANDERA_BEHAVIOR_BROADCAST_EVENT_DISPATCH_STRATEGY_H
#define CANDERA_BEHAVIOR_BROADCAST_EVENT_DISPATCH_STRATEGY_H


#include <CanderaBehavior/BehaviorBase/EventDispatchStrategy.h>

namespace Candera {
/** @addtogroup BehaviorBase
  * @{
  */

    /**
     * @brief Broadcast strategy: the event will be dispatched first for the node with a Direct strategy 
     * and then for each of its children again with the Broadcast strategy
     */
    class BroadcastEventDispatchStrategy : public EventDispatchStrategy
    {
    public:
        /**
         * Retrieves an instance of BroadcastEventDispatchStrategy.
         * @return An instance of BroadcastEventDispatchStrategy.
         */
        static BroadcastEventDispatchStrategy& GetInstance();

        /**
         * Broadcasts and dispatches the event starting at the given node and traversing through the complete subtree.
         * @param node The node to start traversing with.
         * @param event
         * @param dispatchResult
         * @param condition
         */
        static void BroadcastDispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);

        /**
         * Calls BroadcastEventDispatchStrategy::BroadcastDispatchEvent to broadcasts and dispatches the event 
         * starting at the given node and traversing through the complete subtree
         * @param node
         * @param event
         * @param dispatchResult
         * @param condition
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1735,"Default argument on virtual function matches the base-class argument it overrides. (See EventDispatchStrategy.h)")
        virtual void DispatchEvent(const AbstractNodePointer& node, const FeatStd::Event& event, EventDispatchResult& dispatchResult, const Condition* condition = 0);
    };
/** @} */
}
#endif //CANDERA_BEHAVIOR_BROADCAST_EVENT_DISPATCH_STRATEGY_H
