//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ActionBehavior.h"

namespace Candera {
    FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaBehavior);

    FEATSTD_RTTI_DEFINITION(InvokeActionEvent, FeatStd::Event)
    FEATSTD_RTTI_DEFINITION(InvokeActionEventDispatchResult, Candera::EventDispatchResult)
    CGI_BEHAVIOR_RTTI_DEFINITION(ActionBehavior)

#ifdef FEATSTD_LOG_ENABLED
    static const Char* SafeLogString(const Char* s)
    {
        return (0 == s) ? "" : s;
    }
#endif

    void InvokeActionEventDispatchResult::AddPostponedActions(const ActionBehaviorArrayProperty& actions)
    {
        for (SizeType i = 0; i < actions.GetCount(); ++i) {
            ActionBehavior* action = actions.Get(i);
            if (0 != action) {
                FEATSTD_LOG_DEBUG("ActionBehavior '%s' on node '%s': postpone action!", SafeLogString(action->GetName()), SafeLogString(action->GetNode().GetName()));
                AddPostponedAction(*action);
            }
        }
    }

    static void ActionInvokeActions(const InvokeActionEvent& invokeActionEvent, const ActionBehaviorArrayProperty& actions);

    static void ActionInvokePostponedActions(const InvokeActionEvent& invokeActionEvent, const ActionBehaviorArrayProperty& actions)
    {
        if (actions.GetCount() > 0) {
            FEATSTD_LOG_DEBUG("ActionBehavior: begin invoking postponed action!");
            ActionInvokeActions(invokeActionEvent, actions);
            FEATSTD_LOG_DEBUG("ActionBehavior: finished invoking postponed action!");
        }
    }

    static void ActionInvokeActions(const InvokeActionEvent& invokeActionEvent, const ActionBehaviorArrayProperty& actions)
    {
        if (actions.GetCount() > 0) {
            InvokeActionEventDispatchResult invokeActionEventDispatchResult;
            for (SizeType i = 0; i < actions.GetCount(); ++i) {
                ActionBehavior* action = actions.Get(i);
                if (0 != action) {
                    FEATSTD_LOG_DEBUG("ActionBehavior '%s' on node '%s': begin invoking action!", SafeLogString(action->GetName()), SafeLogString(action->GetNode().GetName()));
                    action->DispatchEventLocal(invokeActionEvent, invokeActionEventDispatchResult);
                    FEATSTD_LOG_DEBUG("ActionBehavior '%s' on node '%s': finished invoking action!", SafeLogString(action->GetName()), SafeLogString(action->GetNode().GetName()));
                }
            }
            ActionInvokePostponedActions(invokeActionEvent, invokeActionEventDispatchResult.GetPostponedActions());
        }
    }

    static void ActionInvokeActions(const InvokeActionEvent& invokeActionEvent, const ActionBehaviorArrayProperty& actions, InvokeActionEventDispatchResult& invokeActionEventDispatchResult)
    {
        for (SizeType i = 0; i < actions.GetCount(); ++i) {
            ActionBehavior* action = actions.Get(i);
            if (0 != action) {
                FEATSTD_LOG_DEBUG("ActionBehavior '%s' on node '%s': invoking action!", SafeLogString(action->GetName()), SafeLogString(action->GetNode().GetName()));
                action->DispatchEventLocal(invokeActionEvent, invokeActionEventDispatchResult);
            }
        }
    }

    void ActionBehavior::Invoke(const Behavior* invoker, const FeatStd::Event* event, const ActionBehaviorArrayProperty& actions)
    {
        InvokeActionEvent invokeActionEvent(invoker, event);
        ActionInvokeActions(invokeActionEvent, actions);
    }

    void ActionBehavior::Invoke(const Behavior* invoker, const FeatStd::Event* event, const ActionBehaviorArrayProperty& actions, InvokeActionEventDispatchResult& invokeActionEventDispatchResult)
    {
        InvokeActionEvent invokeActionEvent(invoker, event);
        ActionInvokeActions(invokeActionEvent, actions, invokeActionEventDispatchResult);
    }

    void ActionBehavior::Invoke(const Behavior* invoker, const FeatStd::Event* event, const FeatStd::Internal::Vector< ActionBehavior* >& actions, FeatStd::SizeType begin, FeatStd::SizeType end)
    {
        if (actions.Size() > 0) {
            InvokeActionEvent invokeActionEvent(invoker, event);
            InvokeActionEventDispatchResult invokeActionEventDispatchResult;
            for (SizeType i = begin; (i < actions.Size()) && (i < end); ++i) {
                ActionBehavior* action = actions[i];
                if (0 != action) {
                    FEATSTD_LOG_DEBUG("ActionBehavior '%s' on node '%s': invoking action!", SafeLogString(action->GetName()), SafeLogString(action->GetNode().GetName()));
                    action->DispatchEventLocal(invokeActionEvent, invokeActionEventDispatchResult);
                }
            }
            ActionInvokePostponedActions(invokeActionEvent, invokeActionEventDispatchResult.GetPostponedActions());
        }
    }

}
