//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TransitionIdentifierDataType.h"

#include <CanderaAssetLoader/AssetLoaderBase/AssetId.h>

namespace Candera {

    namespace MetaInfo {

        namespace Internal {

#if defined (CANDERA_TRANSITIONS_ENABLED)
            bool DataType<Candera::Transitions::Identifier>::ConvertFromString(Candera::Transitions::Identifier &destination, const Char *buf, AssetProvider* )
            {
                FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaAssetLoader);

                UInt32 tab[4] = {0};
                if (SerializationPlatform::ToBinary<UInt32*>(buf, ",", &tab[0], &tab[4]) != 4) {
                    FEATSTD_LOG_ERROR("Failed to deserialize AssetId");
                    return false;
                }
                Candera::Internal::AssetId assetId = Candera::Internal::AssetIdFunctions::GetAssetId(tab);
                if (!assetId.IsValid()) {
                    FEATSTD_LOG_INFO("No object to convert.");
                    return false;
                }

                Id sceneId = Candera::Internal::AssetIdFunctions::GetLibraryId(assetId);
                Id nodeId = Candera::Internal::AssetIdFunctions::GetNodeId(assetId);

                switch (assetId.m_libraryType) {
                    case Scene2DLib:
                    case Composite2DLib:
                        destination = Transitions::Identifier(Transitions::Identifier::Scene2DType, sceneId, nodeId);
                        break;
                    case SceneLib:
                    case CompositeLib:
                        destination = Transitions::Identifier(Transitions::Identifier::Scene3DType, sceneId, nodeId);
                        break;
                    default:
                        FEATSTD_LOG_WARN("Invalid TransitionRule Identifier in asset.");
                        break;
                }
                return true;
            }
#else
            bool DataType<Candera::Transitions::Identifier>::ConvertFromString(Candera::Transitions::Identifier &, const Char *, AssetProvider*)
            {
                return false;
            }
#endif
        }
    }
}
