//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(THEMEENTRIESCOLLECTION_H)
#define THEMEENTRIESCOLLECTION_H

#include <Candera/Environment.h>
#include <CanderaAssetLoader/AssetLoaderBase/ObjectMap.h>

namespace Candera {
    class ThemeEntriesCollection {
        public:
            static ThemeEntriesCollection* Create();
            void Dispose();
            ~ThemeEntriesCollection();

            void SetEntryPath(const Char* name, const Char* path);
            const Char* GetEntryPath(const Char* name);

        private:
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704,Candera::ThemeEntriesCollection::ThemeEntriesCollection, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
            ThemeEntriesCollection();
            FEATSTD_MAKE_CLASS_UNCOPYABLE(ThemeEntriesCollection);

            Internal::ObjectMap<const Char*> m_entryPaths;
    };
}

#endif //THEMEENTRIESCOLLECTION_H
