//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ThemeEntriesCollection.h"

namespace Candera {
    ThemeEntriesCollection::ThemeEntriesCollection()
    {
    }

    ThemeEntriesCollection::~ThemeEntriesCollection()
    {
        for (Internal::ObjectMap<const Char*>::MapIterator it = m_entryPaths.Begin(); m_entryPaths.IsIteratorValid(it); it = m_entryPaths.Remove(it)) {
            ASSETLOADER_DELETE_ARRAY(it->GetValue());
        }
    }

    ThemeEntriesCollection* ThemeEntriesCollection::Create()
    {
        return ASSETLOADER_TRANSIENT_NEW(ThemeEntriesCollection);
    }

    void ThemeEntriesCollection::Dispose()
    {
        ASSETLOADER_DELETE(this);
    }

    void ThemeEntriesCollection::SetEntryPath(const Char* name, const Char* path)
    {
        Char* copiedPath = 0;
        if (path != 0) {
            ASSETLOADER_DELETE_ARRAY(m_entryPaths[name]);
            SizeType bufferLen = StringPlatform::Length(path) + 1;
            copiedPath = ASSETLOADER_TRANSIENT_NEW_ARRAY(Char, bufferLen);
            if (copiedPath != 0) {
                StringPlatform::Copy(copiedPath, path);
            }
        }
        m_entryPaths[name] = copiedPath;
    }

    const Char* ThemeEntriesCollection::GetEntryPath(const Char* name)
    {
        Internal::ObjectMap<const Char*>::MapIterator it = m_entryPaths.Find(name);
        if (m_entryPaths.IsIteratorValid(it)) {
            return it->GetValue();
        }

        return 0;
    }
}
