//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PropertyDefinition.h"

namespace Candera {
    namespace Internal {

        PropertyDefinition::PropertyDefinition(const Char* name, const Char* widgetPath, const Char* widgetPropertyName) :
            m_name(name),
            m_widgetPath(widgetPath),
            m_widgetPropertyName(widgetPropertyName)
        {
        }

        PropertyDefinition::PropertyDefinition(const PropertyDefinition& other) :
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1554, Candera::PropertyDefinition::m_name, CANDERA_LINT_REASON_ASSOCIATION)
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1554, Candera::PropertyDefinition::m_widgetPath, CANDERA_LINT_REASON_ASSOCIATION)
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1554, Candera::PropertyDefinition::m_widgetPropertyName, CANDERA_LINT_REASON_ASSOCIATION)
            m_name(other.m_name),
            m_widgetPath(other.m_widgetPath),
            m_widgetPropertyName(other.m_widgetPropertyName)
        {
        }

        PropertyDefinition::~PropertyDefinition(void)
        {
            m_name = 0;
            m_widgetPath = 0;
            m_widgetPropertyName = 0;
        }

        PropertyDefinition& PropertyDefinition::operator=(const PropertyDefinition& other)
        {
            if (&other != this) {
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1555, Candera::Internal::PropertyDefinition::m_name, CANDERA_LINT_REASON_ASSOCIATION)
                m_name = other.m_name;
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1555, Candera::Internal::PropertyDefinition::m_widgetPath, CANDERA_LINT_REASON_ASSOCIATION)
                m_widgetPath = other.m_widgetPath;
                CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1555, Candera::Internal::PropertyDefinition::m_widgetPropertyName, CANDERA_LINT_REASON_ASSOCIATION)
                m_widgetPropertyName = other.m_widgetPropertyName;
            }

            return *this;
        }
    }
}
