//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <FeatStd/Diagnostics/Debug.h>
#include <FeatStd/Util/PointerUtil.h>
#include <CanderaPlatform/OS/MemoryPlatform.h>
#include "MemoryAssetRepository.h"

namespace Candera {
    MemoryAssetRepository::MemoryAssetRepository(Handle memoryStart) :
        m_memoryStart(static_cast<SizeType>(memoryStart)),
        m_filePos(0)
    {
    }

    MemoryAssetRepository::~MemoryAssetRepository()
    {
        m_memoryStart = 0;
    }

    bool MemoryAssetRepository::Initialize()
    {
        m_filePos = m_memoryStart;
        return true;
    }

    SizeType MemoryAssetRepository::AssetRead(void* buffer, SizeType elementSize, SizeType count)
    {
        SizeType size = elementSize * count;
        MemoryPlatform::Copy(buffer, FeatStd::Internal::ScalarToPointer<const void*>(m_filePos), size);

        m_filePos += size;
        return count;
    }

    bool MemoryAssetRepository::AssetSeek(OffsetType offset, AssetSeekMark mark)
    {
        if (mark == AssetRepository::Begin) {
            m_filePos = m_memoryStart + offset;
        }
        else if (mark == AssetRepository::Current) {
            m_filePos += offset;
        }
        else {
            //FEATSTD_DEBUG_FAIL
            FEATSTD_DEBUG_FAIL();
        }
        return true;
    }

    OffsetType MemoryAssetRepository::AssetTell()
    {
        return m_filePos;
    }

    SizeType MemoryAssetRepository::GetConstData(const void ** buffer, SizeType elementSize, SizeType count)
    {
        SizeType size = elementSize * count;
        *buffer = FeatStd::Internal::ScalarToPointer<const void*>(m_filePos);

        m_filePos += size;
        return count;
    }

    bool MemoryAssetRepository::Finalize()
    {
        m_filePos = 0;
        return true;
    }
} //namespace Candera
