//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DynamicAssetConfig_H)
    #define CANDERA_DynamicAssetConfig_H

#include <Candera/System/Container/Vector.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetConfig.h>

namespace Candera {

    /** @addtogroup AssetLoaderBase
     *  @{
     */

    /**
     *  @brief  DynamicAssetConfig is used for asset configurations which change during runtime.
     *
     *  Asset repositories can be added and removed even if the asset provider is already initialized.
     */
    class DynamicAssetConfig : public AssetConfig {
        public:
            /**
             *  Constructor
             */
            DynamicAssetConfig() {}

            /**
             *  Destructor
             */
            virtual ~DynamicAssetConfig() {}

            // overrides AssetConfig::GetAssetRepository
            virtual AssetRepository* GetAssetRepository(UInt16 index) const;

            // overrides AssetConfig::GetAssetRepositoryCount
            virtual UInt16 GetAssetRepositoryCount() const;

            /**
             * Adds a repository during runtime
             */
            void AddRepository(AssetRepository* assetRepository);

            /**
             * Removea a repository during runtime
             */
            void RemoveRepository(AssetRepository* assetRepository);

        private:
            typedef Internal::Vector<AssetRepository*> RepositoryList;

            RepositoryList m_repositoryList;
    };

    /// @}

}   // namespace Candera

#endif  // CANDERA_DynamicAssetConfig_H
