//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEFAULTASSETPROVIDERINTERNAL_H)
#define CANDERA_DEFAULTASSETPROVIDERINTERNAL_H

#include <Candera/Environment.h>
#include <Candera/System/Container/Vector.h>
#include <CanderaPlatform/OS/FilePlatform.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/Generic/TypedCffAssetProvider.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetValidation.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetDescriptor.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetGroup.h>

#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/AnimationPlayerAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/AnimationGroupAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/CameraGroupAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/StateMachineAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/BitmapAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/GraphicDeviceUnitAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/DisplayAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/StyleAssetBuilder.h>
#ifdef CANDERA_SCRIPTING_ENABLED
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/ScriptAssetBuilder.h>
#endif
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/ThemeAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/BinaryThemeAssetBuilder.h>
#include <CanderaAssetLoader/AssetLoaderBase/AssetBuilders/LanguagePackAssetBuilder.h>

#ifdef CANDERA_3D_ENABLED
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/AppearanceAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/AppearanceCollectionAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/BitmapTextureImageAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/RenderModeAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/MaterialAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/NodeAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/CompositeGroupAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/SceneContextAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/ShaderAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/ShaderParamSetterAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/TextureAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/VertexBufferAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/ReferencedTemplateAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader3D/AssetBuilders/SharedClearModeAssetBuilder.h>
#endif

#ifdef CANDERA_2D_ENABLED
    #include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/BitmapImage2DAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/Scene2DContextAssetBuilder.h>
    #include <CanderaAssetLoader/AssetLoader2D/AssetBuilders/CompositeGroup2DAssetBuilder.h>
#endif

#include <FeatStd/MemoryManagement/SharedPointer.h>

namespace Candera {

    struct AssetData;
    class AssetRepository;
    class AssetConfig;

    namespace Internal {

        struct DefaultAssetProviderInternal
        {
            DefaultAssetProviderInternal(DefaultAssetProvider* provider):
                m_displayProvider(provider),
                m_gduProvider(provider),
                m_bitmapProvider(provider),
                m_animationPlayerProvider(provider),
                m_compositeAnimationPlayerProvider(provider),
                m_animationGroupPlayerProvider(provider),
                m_styleProvider(provider),
                m_binaryThemeProvider(provider),
                m_themeProvider(provider), 
#ifdef CANDERA_SCRIPTING_ENABLED
                m_scriptProvider(provider),
#endif
                m_cultureProvider(provider),
                m_cameraGroupProvider(provider),
                m_stateMachineProvider(provider),
                m_currentLanguagePack(),
                m_currentLanguagePackId(AssetId::InvalidId()),
                m_currentLanguagePackAssetDataHandle()
#ifdef CANDERA_2D_ENABLED
                , m_compositeGroup2DProvider(provider)
                , m_scene2DProvider(provider)
                , m_bitmapImage2DProvider(provider)
                , m_currentCompositeGroup2DBuild(0)
#endif //CANDERA_2D_ENABLED
#ifdef CANDERA_3D_ENABLED
                ,m_shaderProvider(provider)
                ,m_appearanceProvider(provider)
                ,m_appearanceCollectionProvider(provider)
                ,m_renderModeProvider(provider)
                ,m_materialProvider(provider)
                ,m_textureProvider(provider)
                ,m_shaderParamSetterProvider(provider)
                ,m_vertexBufferProvider(provider)
                ,m_sceneProvider(provider)
                ,m_referenceTemplateProvider(provider)
                ,m_compositeGroupProvider(provider)
                ,m_bitmapTextureImageProvider(provider)
                ,m_clearModeProvider(provider)
                ,m_currentCompositeGroupBuild(0)
#endif //CANDERA_3D_ENABLED
            {
            }
            Candera::Internal::CffCachingAssetProvider<Candera::Internal::DisplayData*> m_displayProvider;
            Candera::Internal::CffCachingAssetProvider<GraphicDeviceUnit*> m_gduProvider;
            Candera::Internal::CffNonCachingAssetProvider<Bitmap::SharedPointer> m_bitmapProvider;

            Candera::Internal::CffCachingAssetProvider<Animation::AnimationPlayer::SharedPointer> m_animationPlayerProvider;
            Candera::Internal::CffNonCachingAssetProvider<Animation::AnimationPlayer::SharedPointer> m_compositeAnimationPlayerProvider;
            Candera::Internal::CffCachingAssetProvider<Animation::AnimationGroupPlayer::SharedPointer> m_animationGroupPlayerProvider;
            Candera::Internal::CffCachingAssetProvider<Candera::TextRendering::SharedStyle::SharedPointer> m_styleProvider;
            Candera::Internal::CffCachingAssetProvider<Candera::Internal::BinaryTheme*> m_binaryThemeProvider;
            Candera::Internal::CffCachingAssetProvider<Theme*> m_themeProvider;
#ifdef CANDERA_SCRIPTING_ENABLED
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Scripting::Script> > m_scriptProvider;
#endif
            Candera::Internal::CachingAssetProvider<Globalization::Culture::SharedPointer> m_cultureProvider;
            Candera::Internal::CffCachingAssetProvider<CameraGroup*> m_cameraGroupProvider;
            Candera::Internal::CffNonCachingAssetProvider<Candera::Internal::StateMachineBehaviorData*> m_stateMachineProvider;
            Globalization::LanguagePack::SharedPointer m_currentLanguagePack;
            AssetId m_currentLanguagePackId;
            AssetDataHandle m_currentLanguagePackAssetDataHandle;
    #ifdef CANDERA_2D_ENABLED
            Candera::Internal::CffNonCachingAssetProvider<Candera::CompositeGroup2D*, Candera::Internal::Composite2DInstanceBuilder> m_compositeGroup2DProvider;
            Candera::Internal::CffCachingAssetProvider<Scene2DContext*> m_scene2DProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<BitmapImage2D> > m_bitmapImage2DProvider;
            CompositeGroup2D* m_currentCompositeGroup2DBuild;
    #endif //CANDERA_2D_ENABLED
    #ifdef CANDERA_3D_ENABLED
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Shader> > m_shaderProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Appearance> > m_appearanceProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Appearance>, Candera::Internal::AppearanceCollectionAssetBuilder> m_appearanceCollectionProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<RenderMode> > m_renderModeProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Material> > m_materialProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<Texture> > m_textureProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<GenericShaderParamSetter> > m_shaderParamSetterProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<VertexBuffer> > m_vertexBufferProvider;
            Candera::Internal::CffCachingAssetProvider<SceneContext*> m_sceneProvider;
            Candera::Internal::CffCachingAssetProvider<Candera::Internal::ReferencedTemplate*> m_referenceTemplateProvider;
            Candera::Internal::CffNonCachingAssetProvider<Candera::CompositeGroup*, Candera::Internal::CompositeInstanceBuilder> m_compositeGroupProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<BitmapTextureImage> > m_bitmapTextureImageProvider;
            Candera::Internal::CffCachingAssetProvider<MemoryManagement::SharedPointer<SharedClearMode> > m_clearModeProvider;
            CompositeGroup* m_currentCompositeGroupBuild;
    #endif //CANDERA_3D_ENABLED
        };

    }
}

#endif // CANDERA_DEFAULTASSETPROVIDERINTERNAL_H
