//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DefaultAssetConfig.h"

namespace Candera {

    DefaultAssetConfig::DefaultAssetConfig() :
        m_count(0),
        m_asssetRepositories(0)
    {
    }

    DefaultAssetConfig::~DefaultAssetConfig()
    {
        m_asssetRepositories = 0;
        m_count = 0;
    }

    void DefaultAssetConfig::Initialize(AssetRepository** assetRepositories, UInt16 count)
    {
        m_asssetRepositories = assetRepositories;
        m_count = count;
    }

    AssetRepository* DefaultAssetConfig::GetAssetRepository(UInt16 index) const
    {
        return ((index < m_count) && (m_asssetRepositories != 0)) ? m_asssetRepositories[index] : 0;
    }

    UInt16 DefaultAssetConfig::GetAssetRepositoryCount() const
    {
        return m_count;
    }

}   // namespace Candera
