//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef WidgetCollection_CffReader_H
#define WidgetCollection_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for WidgetCollection
    static const Int32 CFF_WIDGET_COLLECTION_ITEM_SIZE_OFFSET                                 = (0);
    static const Int32 CFF_WIDGET_COLLECTION_ITEM_TYPE_OFFSET                                 = (4 + CFF_WIDGET_COLLECTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_WIDGET_COLLECTION_CANDERA_NAME_OFFSET                              = (4 + CFF_WIDGET_COLLECTION_ITEM_TYPE_OFFSET);
    static const Int32 CFF_WIDGET_COLLECTION_CANDERA_ID_OFFSET                                = (4 + CFF_WIDGET_COLLECTION_CANDERA_NAME_OFFSET);
    static const Int32 CFF_WIDGET_COLLECTION_WIDGETS_FLAT_PTR_OFFSET                          = (16 + CFF_WIDGET_COLLECTION_CANDERA_ID_OFFSET);
    static const Int32 CFF_WIDGET_COLLECTION_SIZE                                             = (CFF_PTR_SIZE + CFF_WIDGET_COLLECTION_WIDGETS_FLAT_PTR_OFFSET);

    // getter methods for WidgetCollection
    inline Int32 GetWidgetCollectionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_WIDGET_COLLECTION_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetWidgetCollectionItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_WIDGET_COLLECTION_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetWidgetCollectionCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_WIDGET_COLLECTION_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetWidgetCollectionCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_WIDGET_COLLECTION_CANDERA_ID_OFFSET);
    }
    inline Int32 GetWidgetCollectionWidgetsFlatDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_WIDGET_COLLECTION_WIDGETS_FLAT_PTR_OFFSET);
    }
    inline Int32 GetWidgetCollectionWidgetsFlatCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_WIDGET_COLLECTION_WIDGETS_FLAT_PTR_OFFSET);
    }
    inline AssetDataHandle GetWidgetCollectionWidgetsFlatElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_WIDGET_COLLECTION_WIDGETS_FLAT_PTR_OFFSET + (index * CFF_PTR_SIZE));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //WidgetCollection_CffReader_H
