//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef VertexBuffer_CffReader_H
#define VertexBuffer_CffReader_H

#include "BinaryItemCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for VertexBuffer
    static const Int32 CFF_VERTEX_BUFFER_VERTICES_LENGTH_OFFSET                               = (CFF_BINARY_ITEM_SIZE);
    static const Int32 CFF_VERTEX_BUFFER_VERTICES_PTR_OFFSET                                  = (4 + CFF_VERTEX_BUFFER_VERTICES_LENGTH_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_VERTEX_STRIDE_OFFSET                                 = (CFF_PTR_SIZE + CFF_VERTEX_BUFFER_VERTICES_PTR_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_VERTEX_COUNT_OFFSET                                  = (4 + CFF_VERTEX_BUFFER_VERTEX_STRIDE_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_VERTEX_ATTRIBUTES_PTR_OFFSET                         = (4 + CFF_VERTEX_BUFFER_VERTEX_COUNT_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_MEMORY_POOL_OFFSET                                   = (CFF_PTR_SIZE + CFF_VERTEX_BUFFER_VERTEX_ATTRIBUTES_PTR_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_VERTEX_BUFFER_TYPE_OFFSET                            = (4 + CFF_VERTEX_BUFFER_MEMORY_POOL_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_USAGE_OFFSET                                         = (4 + CFF_VERTEX_BUFFER_VERTEX_BUFFER_TYPE_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_INDEXES_LENGTH_OFFSET                                = (4 + CFF_VERTEX_BUFFER_USAGE_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_INDEXES_PTR_OFFSET                                   = (4 + CFF_VERTEX_BUFFER_INDEXES_LENGTH_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_PRIMITIVE_TYPE_OFFSET                                = (CFF_PTR_SIZE + CFF_VERTEX_BUFFER_INDEXES_PTR_OFFSET);
    static const Int32 CFF_VERTEX_BUFFER_SIZE                                                 = (4 + CFF_VERTEX_BUFFER_PRIMITIVE_TYPE_OFFSET);

    // getter methods for VertexBuffer
    inline Int32 GetVertexBufferVerticesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_VERTICES_LENGTH_OFFSET);
    }
    inline Int32 GetVertexBufferVerticesRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_VERTICES_PTR_OFFSET);
    }
    inline UInt16 GetVertexBufferVertexStride(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt16>(handle, CFF_VERTEX_BUFFER_VERTEX_STRIDE_OFFSET);
    }
    inline UInt32 GetVertexBufferVertexCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_VERTEX_BUFFER_VERTEX_COUNT_OFFSET);
    }
    inline Int32 GetVertexBufferVertexAttributesCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_VERTEX_ATTRIBUTES_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle),  offset); 
    }
    inline AssetDataHandle GetVertexBufferVertexAttributesElementAt(const AssetDataHandle& handle, Int32 elementSize, Int32 index)
    {
        Int32 listOffset =  CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_VERTEX_ATTRIBUTES_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(listHandle, CFF_INT_SIZE + (index * elementSize));
    }
    inline Int32 GetVertexBufferMemoryPool(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_MEMORY_POOL_OFFSET);
    }
    inline Int32 GetVertexBufferVertexBufferType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_VERTEX_BUFFER_TYPE_OFFSET);
    }
    inline Int32 GetVertexBufferUsage(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_USAGE_OFFSET);
    }
    inline UInt32 GetVertexBufferIndexesLength(const AssetDataHandle& handle)
    {
        return CffGetValSafe<UInt32>(handle, CFF_VERTEX_BUFFER_INDEXES_LENGTH_OFFSET);
    }
    inline Int32 GetVertexBufferIndexesRegion(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_INDEXES_PTR_OFFSET);
    }
    inline Int32 GetVertexBufferPrimitiveType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_VERTEX_BUFFER_PRIMITIVE_TYPE_OFFSET);
    }

}}} //namespaces

#endif //VertexBuffer_CffReader_H
