//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef UInt16AnimationKeyframe_CffReader_H
#define UInt16AnimationKeyframe_CffReader_H

#include "BaseAnimationKeyframeCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for UInt16AnimationKeyframe
    static const Int32 CFF_UINT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET                        = (CFF_BASE_ANIMATION_KEYFRAME_SIZE);
    static const Int32 CFF_UINT_16ANIMATION_KEYFRAME_SIZE                                     = (CFF_PTR_SIZE + CFF_UINT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);

    // getter methods for UInt16AnimationKeyframe
    inline Int32 GetUInt16AnimationKeyframeValuesCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_UINT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET);
    }
    inline UInt16 GetUInt16AnimationKeyframeValuesElementAt(const AssetDataHandle& handle, Int32 index)
    {
        return CffGetValSafe<UInt16>(handle, CFF_INT_SIZE + CFF_UINT_16ANIMATION_KEYFRAME_VALUES_PTR_OFFSET + (index * CFF_UINT16_SIZE));
    }

}}} //namespaces

#endif //UInt16AnimationKeyframe_CffReader_H
