//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Transition_CffReader_H
#define Transition_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Transition
    static const Int32 CFF_TRANSITION_TRANSITION_NAME_OFFSET                                  = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_TRANSITION_TARGET_STATE_INDEX_OFFSET                               = (4 + CFF_TRANSITION_TRANSITION_NAME_OFFSET);
    static const Int32 CFF_TRANSITION_CONDITIONINDEX_OFFSET                                   = (4 + CFF_TRANSITION_TARGET_STATE_INDEX_OFFSET);
    static const Int32 CFF_TRANSITION_NO_ACTIONS_OFFSET                                       = (4 + CFF_TRANSITION_CONDITIONINDEX_OFFSET);
    static const Int32 CFF_TRANSITION_SIZE                                                    = (4 + CFF_TRANSITION_NO_ACTIONS_OFFSET);

    // getter methods for Transition
    inline Int32 GetTransitionTransitionName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_TRANSITION_TRANSITION_NAME_OFFSET);
        return nameIndex;
    }
    inline Int32 GetTransitionTargetStateIndex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_TARGET_STATE_INDEX_OFFSET);
    }
    inline Int32 GetTransitionConditionindex(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_CONDITIONINDEX_OFFSET);
    }
    inline Int32 GetTransitionNoActions(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TRANSITION_NO_ACTIONS_OFFSET);
    }

}}} //namespaces

#endif //Transition_CffReader_H
