//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef Theme_CffReader_H
#define Theme_CffReader_H

#include "CanderaObjectCffReader.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for Theme
    static const Int32 CFF_THEME_IS_MASTER_OFFSET                                             = (CFF_CANDERA_OBJECT_SIZE);
    static const Int32 CFF_THEME_CHILDREN_PTR_OFFSET                                          = (4 + CFF_THEME_IS_MASTER_OFFSET);
    static const Int32 CFF_THEME_SIZE                                                         = (CFF_PTR_SIZE + CFF_THEME_CHILDREN_PTR_OFFSET);

    // getter methods for Theme
    inline bool GetThemeIsMaster(const AssetDataHandle& handle)
    {
        return CffGetValSafe<bool>(handle, CFF_THEME_IS_MASTER_OFFSET);
    }
    inline Int32 GetThemeChildrenDataSize(const AssetDataHandle& handle)
    {
        return CffGetVal<Int32>(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(handle, CFF_THEME_CHILDREN_PTR_OFFSET)); 
    }
    inline Int32 GetThemeChildrenCount(const AssetDataHandle& handle)
    {
        Int32 offset = CffGetValSafe<Int32>(handle, CFF_THEME_CHILDREN_PTR_OFFSET);
        return CffGetValSafe<Int32>(CffGetAssetLibHandle(handle), CFF_INT_SIZE +  offset); 
    }
    inline AssetDataHandle GetThemeChildrenElementAt(const AssetDataHandle& handle, Int32 index)
    {
        Int32 listOffset = CffGetValSafe<Int32>(handle, CFF_THEME_CHILDREN_PTR_OFFSET);
        const AssetDataHandle& listHandle = CffGetHandle(CffGetAssetLibHandle(handle), listOffset);
        return CffGetHandle(CffGetAssetLibHandle(handle), CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + (index * CFF_PTR_SIZE)));
    }

}}} //namespaces

#endif //Theme_CffReader_H
