//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)                    
// All rights reserved.                                                   
// -----------------------------------------------------                  
// This document contains proprietary information belonging to            
// Socionext Embedded Software Austria GmbH (SESA).                       
// Passing on and copying of this document, use and communication         
// of its contents is not permitted without prior written authorization.  
//########################################################################

// Generated from CffAssetReaderGenerator.

#ifndef TextureCollection_CffReader_H
#define TextureCollection_CffReader_H

#include "CffAssetReaderBase.h"

namespace Candera { namespace Internal { namespace CFFReader {

    // constants for TextureCollection
    static const Int32 CFF_TEXTURE_COLLECTION_ITEM_SIZE_OFFSET                                = (0);
    static const Int32 CFF_TEXTURE_COLLECTION_ITEM_TYPE_OFFSET                                = (4 + CFF_TEXTURE_COLLECTION_ITEM_SIZE_OFFSET);
    static const Int32 CFF_TEXTURE_COLLECTION_CANDERA_NAME_OFFSET                             = (4 + CFF_TEXTURE_COLLECTION_ITEM_TYPE_OFFSET);
    static const Int32 CFF_TEXTURE_COLLECTION_CANDERA_ID_OFFSET                               = (4 + CFF_TEXTURE_COLLECTION_CANDERA_NAME_OFFSET);
    static const Int32 CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET                  = (16 + CFF_TEXTURE_COLLECTION_CANDERA_ID_OFFSET);
    static const Int32 CFF_TEXTURE_COLLECTION_SIZE                                            = (CFF_PTR_SIZE + CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET);

    // getter methods for TextureCollection
    inline Int32 GetTextureCollectionItemSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_COLLECTION_ITEM_SIZE_OFFSET);
    }
    inline Int32 GetTextureCollectionItemType(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_COLLECTION_ITEM_TYPE_OFFSET);
    }
    inline Int32 GetTextureCollectionCanderaName(const AssetDataHandle& handle)
    {
        Int32 nameIndex = CffGetValSafe<Int32>(handle, CFF_TEXTURE_COLLECTION_CANDERA_NAME_OFFSET);
        return nameIndex;
    }
    inline const UInt32* GetTextureCollectionCanderaId(const AssetDataHandle& handle)
    {
        return CffGetPtrSafe<UInt32>(handle, CFF_TEXTURE_COLLECTION_CANDERA_ID_OFFSET);
    }
    inline Int32 GetTextureCollectionChildrenAttachmentDataSize(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET);
    }
    inline Int32 GetTextureCollectionChildrenAttachmentCount(const AssetDataHandle& handle)
    {
        return CffGetValSafe<Int32>(handle, CFF_INT_SIZE + CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET);
    }
    inline Int32 GetTextureCollectionChildrenAttachmentTypeOfElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = handle;
        return CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET + (index * (CFF_INT_SIZE + CFF_PTR_SIZE)));
    }
    inline const UInt32* GetTextureCollectionChildrenAttachmentIdOfElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = handle;
        Int32 offset = CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET + CFF_PTR_SIZE + (index * (CFF_INT_SIZE + CFF_PTR_SIZE)));
        return CffGetPtr<UInt32>(CffGetAssetLibHandle(handle), offset);
    }
    inline AssetDataHandle GetTextureCollectionChildrenAttachmentElementAt(const AssetDataHandle& handle, Int32 index)
    {
        const AssetDataHandle& listHandle = handle;
        Int32 offset = CffGetValSafe<Int32>(listHandle, CFF_INT_SIZE + CFF_INT_SIZE + CFF_TEXTURE_COLLECTION_CHILDREN_ATTACHMENT_PTR_OFFSET + CFF_PTR_SIZE + (index * (CFF_INT_SIZE + CFF_PTR_SIZE)));
        return CffGetHandle(CffGetAssetLibHandle(handle), offset);
    }

}}} //namespaces

#endif //TextureCollection_CffReader_H
